/*
 * Copyright 2006, 2007 Odysseus Software GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * Additions/modifications to this source file by Oracle USA, Inc. 2007, 2008, 2009
 */
package de.odysseus.el.tree.impl.ast;


import de.odysseus.el.misc.TypeConversions;
import de.odysseus.el.tree.Bindings;
import de.odysseus.el.tree.Node;

import oracle.adfnmc.el.ELContext;
import oracle.adfnmc.el.ELException;
import oracle.adfnmc.el.event.generic.ValueChangeListener;


public final class AstChoice
  extends AstRightValue
{
  private final AstNode question, yes, no;

  public AstChoice(AstNode question, AstNode yes, AstNode no)
  {
    this.question = question;
    this.yes = yes;
    this.no = no;
  }

  public Object eval(Bindings bindings, ELContext context)
    throws ELException
  {
    Boolean value = TypeConversions.coerceToBoolean(question.eval(bindings, context));
    return value.booleanValue() ? yes.eval(bindings, context): no.eval(bindings, context);
  }

  public String toString()
  {
    return "?";
  }

  public void appendStructure(StringBuffer b, Bindings bindings)
  {
    question.appendStructure(b, bindings);
    b.append(" ? ");
    yes.appendStructure(b, bindings);
    b.append(" : ");
    no.appendStructure(b, bindings);
  }

  public int getCardinality()
  {
    return 3;
  }

  /**
   *
   * @param i
   * @return
   */
  // Mobile: changed signature
  //public AstNode getChild(int i) {
  public Node getChild(int i)
  {
    return i == 0 ? question: i == 1 ? yes: i == 2 ? no: null;
  }

  /**
   *
   * @param bindings
   * @param context
   * @param listener
   */
  // Mobile: added behavior
  public void addValueChangeListener(Bindings bindings, ELContext context, ValueChangeListener listener)
  {
    this.question.addValueChangeListener(bindings, context, listener);
    this.yes.addValueChangeListener(bindings, context, listener);
    this.no.addValueChangeListener(bindings, context, listener);
  }

  /**
   *
   * @param bindings
   * @param context
   * @param listener
   */
  // Mobile: added behavior
  public void removeValueChangeListener(Bindings bindings, ELContext context, ValueChangeListener listener)
  {
    this.question.removeValueChangeListener(bindings, context, listener);
    this.yes.removeValueChangeListener(bindings, context, listener);
    this.no.removeValueChangeListener(bindings, context, listener);
  }
}
