/*
 * Copyright 2006, 2007 Odysseus Software GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * Additions/modifications to this source file by Oracle USA, Inc. 2007, 2008, 2009
 */
package de.odysseus.el.tree.impl.ast;


import de.odysseus.el.tree.Bindings;
import de.odysseus.el.tree.Node;

import oracle.adfnmc.el.ELContext;
import oracle.adfnmc.el.ELException;


public final class AstBracket
  extends AstProperty
{
  private final AstNode property;

  public AstBracket(AstNode base, AstNode property, boolean lvalue, boolean strict)
  {
    super(base, lvalue, strict);
    this.property = property;
  }

  protected Object getProperty(Bindings bindings, ELContext context)
    throws ELException
  {
    return property.eval(bindings, context);
  }

  public String toString()
  {
    return "[...]";
  }

  public void appendStructure(StringBuffer b, Bindings bindings)
  {
    // getChild(0).appendStructure(b, bindings);
    ((AstNode) getChild(0)).appendStructure(b, bindings);
    b.append("[");
    // getChild(1).appendStructure(b, bindings);
    ((AstNode) getChild(1)).appendStructure(b, bindings);
    b.append("]");
  }

  public int getCardinality()
  {
    return 2;
  }

  /**
   *
   * @param i
   * @return
   */
  // Mobile: changed signature
  //public AstNode getChild(int i)
  public Node getChild(int i)
  {
    return i == 1 ? property: super.getChild(i);
  }
}
