/*
 * Copyright 2006, 2007 Odysseus Software GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * Additions/modifications to this source file by Oracle USA, Inc. 2007, 2008, 2009
 */
package de.odysseus.el.tree.impl;


import de.odysseus.el.misc.LocalMessages;
import de.odysseus.el.tree.Tree;
import de.odysseus.el.tree.TreeBuilder;
import de.odysseus.el.tree.impl.Parser.ParseException;
import de.odysseus.el.tree.impl.Scanner.ScanException;

import oracle.adfnmc.el.ELException;
import oracle.adfnmc.util.Number;


/**
 * Tree builder.
 *
 * @author Christoph Beck
 */
public class Builder
  implements TreeBuilder
{
  // Mobile: unsupported language feature	
  //private static final long serialVersionUID = 1L;

  // Mobile: unsupported language feature
  ///**
  // * Feature enumeration type.
  // */
  //public static enum Feature
  //{
  //  /**
  //   * Method invocations as in <code>${foo.bar(1)}</code> are a <em>JUEL</em> extension. The
  //   * method to be invoked is resolved at evaluation just like properties. That is, a specialized
  //   * resolver will have to be provided at evaluation time.
  //   */
  //  METHOD_INVOCATIONS,
  //
  //  /**
  //   * For some reason we don't understand, the specification does not allow to resolve
  //   * <code>null</code> property values. E.g. <code>${map[key]}</code> will always return
  //   * <code>null</code> if <code>key</code> evaluates to <code>null</code>. Enabling this
  //   * feature will allow <em>JUEL</em> to pass <code>null</code> to the property resolvers just
  //   * like any other property value.
  //   */
  //  NULL_PROPERTIES;
  //}

  /**
   *
   */
  // Mobile: substituted type
  public static class Feature
  {
    public static int METHOD_INVOCATIONS = 0;
    public static int NULL_PROPERTIES = 1;
  }

  // Mobile: unsupported type	
  //private final EnumSet<Feature> features;

  public Builder()
  {
    // Mobile: removed behavior
    // Mobile: unsupported type dependency
    //this.features = EnumSet.noneOf(Feature.class);
  }

  /**
   *
   * @param features
   */
  // Mobile: unsupported language feature
  // Mobile: changed signature	
  //public Builder(Feature... features)
  public Builder(Feature[] features)
  {
    // Mobile: removed behavior
    // Mobile: unsupported type dependency
    //if (features == null || features.length == 0)
    //{
    //	this.features = EnumSet.noneOf(Feature.class);
    //}
    //else if (features.length == 1)
    //{
    //	this.features = EnumSet.of(features[0]);
    //}
    //else
    //{
    //	Feature[] rest = new Feature[features.length-1];
    //	for (int i = 1; i < features.length; i++)
    //	{
    //		rest[i-1] = features[i];
    //	}
    //	this.features = EnumSet.of(features[0], rest);
    //}		
  }

  /**
   * Parse an integer literal.
   *
   * @param string
   *            string to parse
   * @return <code>Long.valueOf(string)</code>
   */
  // Mobile: changed signature
  // Mobile: substituted type
  protected Number parseInteger(String string)
    throws NumberFormatException
  {
    // Mobile: substituted type
    //return Long.valueOf(string);
    long val = Long.parseLong(string);
    return new Number(val);
  }

  /**
   * Parse a floating point literal.
   *
   * @param string
   *            string to parse
   * @return <code>Double.valueOf(string)</code>
   */
  // Mobile: changed signature
  // Mobile: substituted type
  protected Number parseFloat(String string)
    throws NumberFormatException
  {
    // Mobile: substituted type
    //return Double.valueOf(string);
    double val = Double.parseDouble(string);
    return new Number(val);
  }

  /**
   * @return <code>true</code> iff the specified feature is supported.
   */
  // Mobile: changed signature
  // Mobile: substituted type
  //public boolean isEnabled(Feature feature)
  public boolean isEnabled(int feature)
  {
    // Mobile: changed behavior - all feature codes effectively enabled	
    //return features.contains(feature);
    return true;
  }

  /**
   * Parse expression.
   */
  public Tree build(String expression)
    throws ELException
  {
    try
    {
      return new Parser(this, expression).tree();
    }
    catch (ScanException e)
    {
      throw new ELException(LocalMessages.get("error.build", expression, e.getMessage()));
    }
    catch (ParseException e)
    {
      throw new ELException(LocalMessages.get("error.build", expression, e.getMessage()));
    }
  }

  public boolean equals(Object obj)
  {
    if (obj == null || obj.getClass() != getClass())
    {
      return false;
    }
    // Mobile: changed behavior - Builder equality is feature agnostic		
    //return features.equals(((Builder)obj).features);
    return true;
  }

  public int hashCode()
  {
    return getClass().hashCode();
  }

  // Mobile: removed behavior
  ///**
  //* Dump out abstract syntax tree for a given expression
  //*
  //* @param args
  //*            array with one element, containing the expression string
  //*/
  //public static void main(String[] args)
  //{
  //  if (args.length != 1)
  //  {
  //    System.err.println("usage:java " + Builder.class.getName() + " <expression string>");
  //    System.exit(1);
  //  }
  //  PrintWriter out = new PrintWriter(System.out);
  //  Tree tree = null;
  //  try
  //  {
  //    tree = new Builder(Feature.METHOD_INVOCATIONS).build(args[0]);
  //  }
  //  catch (ELException e)
  //  {
  //    System.out.println(e.getMessage());
  //    System.exit(0);
  //  }
  //  NodePrinter.dump(out, tree.getRoot());
  //  if (!tree.getFunctionNodes().iterator().hasNext() && !tree.getIdentifierNodes().iterator().hasNext())
  //  {
  //    out.print(">> ");
  //    try
  //    {
  //      //out.println(tree.getRoot().getValue(null, new SimpleContext(), null));
  //      out.println(tree.getRoot().getValue(null, new SimpleContext(), null).toString());
  //    }
  //    catch (ELException e)
  //    {
  //      out.println(e.getMessage());
  //    }
  //  }
  //
  //  try
  //  {
  //    out.flush();
  //  }
  //  catch (IOException e)
  //  {
  //    System.out.println(e.getMessage());
  //  }
  //}
}
