/*
 * Copyright 2006, 2007 Odysseus Software GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * Additions/modifications to this source file by Oracle USA, Inc. 2007, 2008, 2009
 */
package de.odysseus.el.tree;


import java.util.Vector;

import oracle.adfnmc.el.FunctionMapper;
import oracle.adfnmc.el.VariableMapper;


/**
 * Parsed expression, usually created by a {@link de.odysseus.el.tree.TreeBuilder}. The
 * {@link #bind(FunctionMapper, VariableMapper)} method is used to create
 * {@link de.odysseus.el.tree.Bindings}, which are needed at evaluation time to lookup functions
 * and variables. The tree itself does not contain such information, because it would make the tree
 * depend on the function/variable mapper supplied at parse time.
 *
 * @author Christoph Beck
 */
public class Tree
{
  private final ExpressionNode root;

  // Mobile: substituted type
  //private final Collection<FunctionNode> functions;
  private final Vector functions;

  // Mobile: substituted type
  //private final Collection<IdentifierNode> identifiers;
  private final Vector identifiers;

  private final boolean deferred;


  /**
   *
   * Constructor.
   *
   * @param root
   *            root node
   * @param functions
   *            collection of function nodes
   * @param identifiers
   *            collection of identifier nodes
   */
  // Mobile: changed signature
  // Mobile: substituted type
  //public Tree(ExpressionNode root, Collection<FunctionNode> functions, Collection<IdentifierNode> identifiers, boolean deferred)
  public Tree(ExpressionNode root, Vector functions, Vector identifiers, boolean deferred)
  {
    super();
    this.root = root;
    this.functions = functions;
    this.identifiers = identifiers;
    this.deferred = deferred;
  }

  /**
   * Get function nodes (in no particular order)
   */
  // Mobile: changed signature
  // Mobile: substituted type
  //public Iterable<FunctionNode> getFunctionNodes()
  public Vector getFunctionNodes()
  {
    return functions;
  }

  /**
   * Get identifier nodes (in no particular order)
   */
  // Mobile: changed signature
  // Mobile: substituted type
  //public Iterable<IdentifierNode> getIdentifierNodes()
  public Vector getIdentifierNodes()
  {
    return identifiers;
  }

  /**
   * @return root node
   */
  public ExpressionNode getRoot()
  {
    return root;
  }

  public boolean isDeferred()
  {
    return deferred;
  }

  public String toString()
  {
    return getRoot().getStructuralId(null);
  }

  /**
   * Create a bindings.
   *
   * @param fnMapper
   *            the function mapper to use
   * @param varMapper
   *            the variable mapper to use
   * @return tree bindings
   */
  public Bindings bind(FunctionMapper fnMapper, VariableMapper varMapper)
  {
    return null;

    // Mobile: changed behavior
    // Mobile: removed behavior
    //
    // We need to be able to resolve variables at evaluation time, not just creation time,
    // changed implementation of AstIdentifier to give this desired behavior.
    //
    // The change in implementation basically eliminates the need for a Bindings object, although for now
    // just returning a null one here rather than going in and changing all the signatures of methods
    // that pass this around, although that should happen later.
    // Method[] methods = null;
    //if (!functions.isEmpty())
    //{
    //  if (fnMapper == null)
    //  {
    //    throw new ELException(LocalMessages.get("error.function.nomapper"));
    //  }
    //  methods = new Method[functions.size()];
    //
    //  // Mobile: unsupported language feature
    //  //for (FunctionNode node: functions) {
    //  Enumeration enumFunctions = functions.getElements();
    //  while (enumFunctions.hasMoreElements())
    //  {
    //    FunctionNode node = (FunctionNode) enumFunctions.nextElement();
    //    String image = node.getName();
    //    Method method = null;
    //    int colon = image.indexOf(':');
    //    if (colon < 0)
    //    {
    //      method = fnMapper.resolveFunction("", image);
    //    }
    //    else
    //    {
    //      method = fnMapper.resolveFunction(image.substring(0, colon), image.substring(colon + 1));
    //    }
    //    if (method == null)
    //    {
    //      throw new ELException(LocalMessages.get("error.function.notfound", image));
    //    }
    //    if (method.getParameterTypes().length != node.getParamCount())
    //    {
    //      throw new ELException(LocalMessages.get("error.function.params", image));
    //    }
    //    methods[node.getIndex()] = method;
    //  }
    //}
    //
    //ValueExpression[] expressions = null;
    //if (identifiers.size() > 0)
    //{
    //  expressions = new ValueExpression[identifiers.size()];
    //
    //  // Mobile: unsupported language feature
    //  //for (IdentifierNode node: identifiers) {
    //  Enumeration enumIdentifiers = identifiers.getElements();
    //  while (enumIdentifiers.hasMoreElements())
    //  {
    //    IdentifierNode node = (IdentifierNode) enumIdentifiers.nextElement();
    //
    //    ValueExpression expression = null;
    //    if (varMapper != null)
    //    {
    //      expression = varMapper.resolveVariable(node.getName());
    //    }
    //    expressions[node.getIndex()] = expression;
    //  }
    //}
    //return new Bindings(methods, expressions);
  }
}
