/*
 * Copyright 2006, 2007 Odysseus Software GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * Additions/modifications to this source file by Oracle USA, Inc. 2007, 2008, 2009
 */
package de.odysseus.el.tree;


import java.util.Enumeration;
import java.util.Stack;

import oracle.adfnmc.java.io.PrintWriter;


/**
 * Node pretty printer for debugging purposes.
 *
 * @author Christoph Beck
 */
public class NodePrinter
{
  private static boolean isLastSibling(Node node, Node parent)
  {
    if (parent != null)
    {
      return node == parent.getChild(parent.getCardinality() - 1);
    }
    return true;
  }

  /**
   *
   * @param writer
   * @param node
   * @param predecessors
   */
  // Mobile: changed signature
  // Mobile: substituted type
  //private static void dump(PrintWriter writer, Node node, Stack<Node> predecessors)
  private static void dump(PrintWriter writer, Node node, Stack predecessors)
  {
    if (!predecessors.isEmpty())
    {
      Node parent = null;

      // Mobile: unsupported language feature
      //for (Node predecessor: predecessors) {
      Enumeration enumPredecessors = predecessors.elements();
      while (enumPredecessors.hasMoreElements())
      {
        Node predecessor = (Node) enumPredecessors.nextElement();

        if (isLastSibling(predecessor, parent))
        {
          writer.print("   ");
        }
        else
        {
          writer.print("|  ");
        }
        parent = predecessor;
      }
      writer.println("|");
    }
    Node parent = null;

    // Mobile: unsupported language feature
    //for (Node predecessor: predecessors) {
    Enumeration enumPredecessors = predecessors.elements();
    while (enumPredecessors.hasMoreElements())
    {
      Node predecessor = (Node) enumPredecessors.nextElement();

      if (isLastSibling(predecessor, parent))
      {
        writer.print("   ");
      }
      else
      {
        writer.print("|  ");
      }
      parent = predecessor;
    }
    writer.print("+- ");
    writer.println(node.toString());

    predecessors.push(node);
    for (int i = 0; i < node.getCardinality(); i++)
    {
      dump(writer, node.getChild(i), predecessors);
    }
    predecessors.pop();
  }

  /**
   *
   * @param writer
   * @param node
   */
  // Mobile: changed signature
  // Mobile: substituted type
  public static void dump(PrintWriter writer, Node node)
  {
    // Mobile: substituted type
    //dump(writer, node, new Stack<Node>());
    dump(writer, node, new Stack());
  }
}
