/*
 * Copyright 2006, 2007 Odysseus Software GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * Additions/modifications to this source file by Oracle USA, Inc. 2007, 2008, 2009
 */
package de.odysseus.el.tree;


import oracle.adfnmc.el.ValueExpression;
import oracle.adfnmc.util.collections.Arrays;


/**
 * Bindings, usually created by a {@link de.odysseus.el.tree.Tree}.
 *
 * @author Christoph Beck
 */
// Mobile: unsupported language feature
// Mobile: changed signature
//public class Bindings implements Serializable {
public class Bindings
{
  // Mobile: unsupported language feature
  //private static final long serialVersionUID = 1L;

  // Mobile: unsupported type
  //private static final Method[] NO_FUNCTIONS = new Method[0];
  private static final Object[] NO_FUNCTIONS = new Object[0];

  private static final ValueExpression[] NO_VARIABLES = new ValueExpression[0];

  // Mobile: removed behavior
  // Mobile: unsupported language feature
  // Mobile: unsupported type dependency
  ///**
  // * Wrap a {@link Method} for serialization.
  // */
  //private static class MethodWrapper
  //  implements Serializable
  //{
  //  private static final long serialVersionUID = 1L;
  //
  //  private transient Method method;
  //
  //
  //  private MethodWrapper(Method method)
  //  {
  //    this.method = method;
  //  }
  //
  //  private void writeObject(ObjectOutputStream out)
  //    throws IOException, ClassNotFoundException
  //  {
  //    out.defaultWriteObject();
  //    out.writeObject(method.getDeclaringClass());
  //    out.writeObject(method.getName());
  //    out.writeObject(method.getParameterTypes());
  //  }
  //
  //  private void readObject(ObjectInputStream in)
  //    throws IOException, ClassNotFoundException
  //  {
  //    in.defaultReadObject();
  //    type = (Class) in.readObject();
  //    String name = (String) in.readObject();
  //    Class[] args = (Class[]) in.readObject();
  //    try
  //    {
  //      method = type.getDeclaredMethod(name, args);
  //    }
  //    catch (NoSuchMethodException e)
  //    {
  //      throw new IOException(e.getMessage());
  //    }
  //  }
  //}

  // Mobile: unsupported type
  //private transient Method[] functions;
  private transient Object[] functions;

  private final ValueExpression[] variables;


  /**
   * Constructor.
   */
  // Mobile: changed signature
  // Mobile: unsupported type dependency
  //public Bindings(Method[] functions, ValueExpression[] variables)
  public Bindings(Object[] functions, ValueExpression[] variables)
  {
    super();

    this.functions = functions == null || functions.length == 0 ? NO_FUNCTIONS: functions;
    this.variables = variables == null || variables.length == 0 ? NO_VARIABLES: variables;
  }

  /**
   * Get function by index.
   *
   * @param index
   *            function index
   * @return method
   */
  // Mobile: changed signature
  // Mobile: unsupported type dependency
  //public Method getFunction(int index)
  public Object getFunction(int index)
  {
    return functions[index];
  }

  /**
   * Get variable by index.
   *
   * @param index
   *            identifier index
   * @return value expression
   */
  public ValueExpression getVariable(int index)
  {
    return variables[index];
  }

  public boolean equals(Object obj)
  {
    if (obj instanceof Bindings)
    {
      Bindings other = (Bindings) obj;
      // Mobile: substituted type
      return Arrays.equals(functions, other.functions) && Arrays.equals(variables, other.variables);
    }
    return false;
  }

  // Mobile: removed behavior
  // Mobile: unsupported method_dependency
  //public int hashCode()
  //{
  //  return Arrays.hashCode(functions) ^ Arrays.hashCode(variables);
  //}

  // Mobile: removed behavior
  // Mobile: unsupported type dependency
  //private void writeObject(ObjectOutputStream out)
  //  throws IOException, ClassNotFoundException
  //{
  //  out.defaultWriteObject();
  //  MethodWrapper[] wrappers = new MethodWrapper[functions.length];
  //  for (int i = 0; i < wrappers.length; i++)
  //  {
  //    wrappers[i] = new MethodWrapper(functions[i]);
  //  }
  //  out.writeObject(wrappers);
  //}

  // Mobile: removed behavior
  // Mobile: unsupported type dependency
  //private void readObject(ObjectInputStream in)
  //  throws IOException, ClassNotFoundException
  //{
  //  in.defaultReadObject();
  //  MethodWrapper[] wrappers = (MethodWrapper[]) in.readObject();
  //  if (wrappers.length == 0)
  //  {
  //    functions = NO_FUNCTIONS;
  //  }
  //  else
  //  {
  //    functions = new Method[wrappers.length];
  //    for (int i = 0; i < functions.length; i++)
  //    {
  //      functions[i] = wrappers[i].method;
  //    }
  //  }
  //}
}
