/*
 * Copyright 2006, 2007 Odysseus Software GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the
 * License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * Additions/modifications to this source file by Oracle USA, Inc. 2007, 2008, 2009
 */
package de.odysseus.el.misc;

import oracle.adfnmc.el.ExpressionFactory;
import oracle.adfnmc.util.Utility;


public class TypeConversions
{
  public static final Class CLASS_INSTANCE = TypeConversions.class;

  private static final ExpressionFactory exprFactory;

  static
  {
    exprFactory = ExpressionFactory.getInstance();
  }

  public static final Boolean coerceToBoolean(Object value)
  {
    return (Boolean) exprFactory.coerceToType(value, Utility.BOOLEAN_CLASS);
  }

  public static final Character coerceToCharacter(Object value)
  {
    return (Character) exprFactory.coerceToType(value, Utility.CHARACTER_CLASS);
  }

  public static final Object coerceToNumber(Object value, Class type)
  {
    return exprFactory.coerceToType(value, type);
  }

  public static final String coerceToString(Object value)
  {
    return (String) exprFactory.coerceToType(value, Utility.STRING_CLASS);
  }

  public static final Object coerceToType(Object value, Class type)
  {
    return exprFactory.coerceToType(value, type);
  }

  public static final boolean isPrimitive(Class type)
  {
    return TypeConversionsImpl.isPrimitive(type);
  }
}
