/*
 * Copyright 2006, 2007 Odysseus Software GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * Additions/modifications to this source file by Oracle USA, Inc. 2007, 2008, 2009
 */
package de.odysseus.el.misc;


import oracle.adfnmc.el.ELException;
import oracle.adfnmc.util.Number;
import oracle.adfnmc.util.Utility;


/**
 * Arithmetic Operations as specified in chapter 1.7.
 *
 * @author Christoph Beck
 */
public class NumberOperations
{
  // Mobile: substituted type
  //private final static Long LONG_ZERO = Long.valueOf(0L);
  private final static Long LONG_ZERO = new Long(0L);


  private final static boolean isDotEe(String value)
  {
    int length = value.length();
    for (int i = 0; i < length; i++)
    {
      switch (value.charAt(i))
      {
        case '.':
        case 'E':
        case 'e':
          return true;
      }
    }
    return false;
  }

  private final static boolean isDotEe(Object value)
  {
    return value instanceof String && isDotEe((String) value);
  }

  // Mobile: removed behavior
  //private static final boolean isFloatOrDouble(Object value)
  //{
  //  return value instanceof Float || value instanceof Double;
  //  return Number.isObjectFloat(value);
  //}

  private static final boolean isFloatOrDoubleOrDotEe(Object value)
  {
    // Mobile: substituted type
    //return isFloatOrDouble(value) || isDotEe(value);
    return Number.isObjectFloat(value) || isDotEe(value);
  }

  // Mobile: removed behavior
  // Mobile: unsupported type dependency
  //private static final boolean isBigDecimalOrBigInteger(Object value)
  //{
  //  return value instanceof BigDecimal || value instanceof BigInteger;
  //}

  // Mobile: removed behavior
  // Mobile: unsupported type dependency
  //private static final boolean isBigDecimalOrFloatOrDoubleOrDotEe(Object value)
  //{
  //  return value instanceof BigDecimal || isFloatOrDoubleOrDotEe(value);
  //}

  // Mobile: removed behavior
  // Mobile: unsupported type dependency
  //private static final BigDecimal toBigDecimal(Object value)
  //{
  //  return TypeConversions.coerceToNumber(value, BigDecimal.class);
  //}

  // Mobile: removed behavior
  // Mobile: unsupported type dependency
  //private static final BigInteger toBigInteger(Object value)
  //{
  //  return TypeConversions.coerceToNumber(value, BigInteger.class);
  //}

  /**
   *
   * @param value
   * @return
   */
  // Mobile: changed signature
  // Mobile: substituted type
  //private static final Double toDouble(Object value)
  private static final double toDouble(Object value)
  {
    return ((Double) TypeConversions.coerceToNumber(value, Utility.DOUBLE_CLASS)).doubleValue();
  }

  /**
   *
   * @param value
   * @return
   */
  // Mobile: changed signature
  // Mobile: substituted type
  //private static final Long toLong(Object value)
  private static final long toLong(Object value)
  {
    return ((Long) TypeConversions.coerceToNumber(value, Utility.LONG_CLASS)).longValue();
  }

  /**
   *
   * @param o1
   * @param o2
   * @return
   */
  // Mobile: changed signature
  //public static final Number add(Object o1, Object o2)
  public static final Object add(Object o1, Object o2)
  {
    if (o1 == null && o2 == null)
    {
      return LONG_ZERO;
    }

    // Mobile: unsupported type
    //if (o1 instanceof BigDecimal || o2 instanceof BigDecimal)
    //{
    //  return toBigDecimal(o1).add(toBigDecimal(o2));
    //}

    if (isFloatOrDoubleOrDotEe(o1) || isFloatOrDoubleOrDotEe(o2))
    {
      // Mobile: unsupported type
      //if (o1 instanceof BigInteger || o2 instanceof BigInteger)
      //{
      //  return toBigDecimal(o1).add(toBigDecimal(o2));
      //}

      // Mobile: substituted type
      //return toDouble(o1) + toDouble(o2);
      return Number.box(toDouble(o1) + toDouble(o2));
    }

    // Mobile: unsupported type
    //if (o1 instanceof BigInteger || o2 instanceof BigInteger)
    //{
    //  return toBigInteger(o1).add(toBigInteger(o2));
    //}

    // Mobile: substituted type
    //return toLong(o1) + toLong(o2);
    return Number.box(toLong(o1) + toLong(o2));
  }

  /**
   *
   * @param o1
   * @param o2
   * @return
   */
  // Mobile: changed signature
  //public static final Number sub(Object o1, Object o2)
  public static final Object sub(Object o1, Object o2)
  {
    if (o1 == null && o2 == null)
    {
      return LONG_ZERO;
    }

    // Mobile: unsupported type
    //if (o1 instanceof BigDecimal || o2 instanceof BigDecimal)
    //{
    //  return toBigDecimal(o1).subtract(toBigDecimal(o2));
    //}

    if (isFloatOrDoubleOrDotEe(o1) || isFloatOrDoubleOrDotEe(o2))
    {
      // Mobile: unsupported type
      //if (o1 instanceof BigInteger || o2 instanceof BigInteger)
      //{
      //  return toBigDecimal(o1).subtract(toBigDecimal(o2));
      //}

      // Mobile: substituted type
      //return toDouble(o1) - toDouble(o2);
      return Number.box(toDouble(o1) - toDouble(o2));
    }

    // Mobile: unsupported type
    //if (o1 instanceof BigInteger || o2 instanceof BigInteger)
    //{
    //  return toBigInteger(o1).subtract(toBigInteger(o2));
    //}

    // Mobile: substituted type
    //return toLong(o1) - toLong(o2);
    return Number.box(toLong(o1) - toLong(o2));
  }

  /**
   *
   * @param o1
   * @param o2
   * @return
   */
  // Mobile: changed signature
  //public static final Number mul(Object o1, Object o2)
  public static final Object mul(Object o1, Object o2)
  {
    if (o1 == null && o2 == null)
    {
      return LONG_ZERO;
    }

    // Mobile: unsupported type
    //if (o1 instanceof BigDecimal || o2 instanceof BigDecimal)
    //{
    //  return toBigDecimal(o1).multiply(toBigDecimal(o2));
    //}

    if (isFloatOrDoubleOrDotEe(o1) || isFloatOrDoubleOrDotEe(o2))
    {
      // Mobile: unsupported type
      //if (o1 instanceof BigInteger || o2 instanceof BigInteger)
      //{
      //  return toBigDecimal(o1).multiply(toBigDecimal(o2));
      //}

      // Mobile: substituted type
      //return toDouble(o1) * toDouble(o2);
      return Number.box(toDouble(o1) * toDouble(o2));
    }

    // Mobile: unsupported type
    //if (o1 instanceof BigInteger || o2 instanceof BigInteger)
    //{
    //  return toBigInteger(o1).multiply(toBigInteger(o2));
    //}

    // Mobile: substituted type
    //return toLong(o1) * toLong(o2);
    return Number.box(toLong(o1) * toLong(o2));
  }

  /**
   *
   * @param o1
   * @param o2
   * @return
   */
  // Mobile: changed signature
  //public static final Number div(Object o1, Object o2)
  public static final Object div(Object o1, Object o2)
  {
    if (o1 == null && o2 == null)
    {
      return LONG_ZERO;
    }

    // Mobile: unsupported type dependency
    //if (isBigDecimalOrBigInteger(o1) || isBigDecimalOrBigInteger(o2))
    //{
    //  return toBigDecimal(o1).divide(toBigDecimal(o2), BigDecimal.ROUND_HALF_UP);
    //}

    // Mobile: substituted type
    //return toDouble(o1) / toDouble(o2);
    return Number.box(toDouble(o1) / toDouble(o2));
  }

  /**
   *
   * @param o1
   * @param o2
   * @return
   */
  // Mobile: changed signature
  //public static final Number mod(Object o1, Object o2)
  public static final Object mod(Object o1, Object o2)
  {
    if (o1 == null && o2 == null)
    {
      return LONG_ZERO;
    }

    // Mobile: unsupported type dependency
    //if (isBigDecimalOrFloatOrDoubleOrDotEe(o1) || isBigDecimalOrFloatOrDoubleOrDotEe(o2))
    //{
    //  return toDouble(o1) % toDouble(o2);
    //}

    if (isFloatOrDoubleOrDotEe(o1) || isFloatOrDoubleOrDotEe(o2))
    {
      // Mobile: substituted type
      //return toDouble(o1) % toDouble(o2);
      return Number.box(toDouble(o1) % toDouble(o2));
    }

    // Mobile: unsupported type
    //if (o1 instanceof BigInteger || o2 instanceof BigInteger)
    //{
    //  return toBigInteger(o1).remainder(toBigInteger(o2));
    //}

    // Mobile: substituted type
    //return toLong(o1) % toLong(o2);
    return Number.box(toLong(o1) % toLong(o2));
  }

  /**
   *
   * @param value
   * @return
   */
  // Mobile: changed signature
  //public static final Number neg(Object value)
  public static final Object neg(Object value)
  {
    if (value == null)
    {
      return LONG_ZERO;
    }

    // Mobile: unsupported type
    //if (value instanceof BigDecimal)
    //{
    //  return ((BigDecimal)value).negate();
    //}

    // Mobile: unsupported type
    //if (value instanceof BigInteger)
    //{
    //  return ((BigInteger)value).negate();
    //}

    if (value instanceof Number)
    {
      return neg(((Number) value).getInnerValue());
    }
    if (value instanceof Double)
    {
      // Mobile: unsupported method
      //return Double.valueOf(-((Double)value).doubleValue());
      return new Double(-((Double) value).doubleValue());
    }
    if (value instanceof Float)
    {
      // Mobile: unsupported method
      //return Float.valueOf(-((Float)value).floatValue());
      return new Float(-((Float) value).floatValue());
    }
    if (value instanceof String)
    {
      if (isDotEe((String) value))
      {
        // Mobile: unsupported method
        //return Double.valueOf(-toDouble(value).doubleValue());
        return new Double(-toDouble(value));
      }
      // Mobile: unsupported method
      //return Long.valueOf(-toLong(value).longValue());
      return new Long(-toLong(value));
    }
    if (value instanceof Long)
    {
      // Mobile: unsupported method
      //return Long.valueOf(-((Long)value).longValue());
      return new Long(-((Long) value).longValue());
    }
    if (value instanceof Integer)
    {
      // Mobile: unsupported method
      //return Integer.valueOf(-((Integer)value).intValue());
      return new Integer(-((Integer) value).intValue());
    }
    if (value instanceof Short)
    {
      // Mobile: unsupported method
      //return Short.valueOf((short)-((Short)value).shortValue());
      return new Short((short) -((Short) value).shortValue());
    }
    if (value instanceof Byte)
    {
      // Mobile: unsupported method
      //return Byte.valueOf((byte)-((Byte)value).byteValue());
      return new Byte((byte) -((Byte) value).byteValue());
    }
    throw new ELException(LocalMessages.get("error.negate", value.getClass()));
  }
}
