/*
 * Copyright 2006, 2007 Odysseus Software GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * Additions/modifications to this source file by Oracle USA, Inc. 2007, 2008, 2009
 */
package de.odysseus.el.misc;


import java.util.Hashtable;


public final class LocalMessages
{
  //  Mobile: substituted type
  private static Hashtable messages = new Hashtable();

  //  Mobile: added behavior
  private static final String ERROR_COERCE_TYPE_KEY = "error.coerce.type";
  private static final String ERROR_PROPERTY_NOT_FOUND_KEY = "error.property.property.notfound";
  private static final String ERROR_IDENTIFIER_PROPERTY_NOT_FOUND_KEY = "error.identifier.property.notfound";
  private static final String ERROR_PROPERTY_BASE_NULL_KEY = "error.property.base.null";
  private static final String ERROR_VALUE_SET_RVALUE_KEY = "error.value.set.rvalue";
  private static final String ERROR_VALUE_NOTYPE_KEY = "error.value.notype";


  static
  {
    messages.put(LocalMessages.ERROR_COERCE_TYPE_KEY, 
                 "Unable to coerce type of resolved value to type Expression created with");
    messages.put(LocalMessages.ERROR_PROPERTY_NOT_FOUND_KEY, 
                 "Unable to resolve property on base object");
    messages.put(LocalMessages.ERROR_IDENTIFIER_PROPERTY_NOT_FOUND_KEY,
                 "Unable to resolve property on object bound to identifer");
    messages.put(LocalMessages.ERROR_PROPERTY_BASE_NULL_KEY, 
                 "Base object is null");
    messages.put(LocalMessages.ERROR_VALUE_SET_RVALUE_KEY, 
                 "Attempting to set an r-Value expression");
    messages.put(LocalMessages.ERROR_VALUE_NOTYPE_KEY, 
                 "Type must be supplied when creating a new Expression");
  }


  // Mobile: removed behavior
  //private static final String BUNDLE_NAME = "de.odysseus.el.misc.LocalStrings";
  //private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle(BUNDLE_NAME);

  /**
   *
   * @param key
   * @return
   */
  // Mobile: changed behavior
  // Mobile: changed signature
  // Mobile: unsupported language feature
  //public static String get(String key, Object... args)
  public static String get(String key)
  {
    // Mobile: removed behavior
    // Mobile: unsupported type dependency
    //String template = null;
    //try
    //{
    //  template = RESOURCE_BUNDLE.getString(key);
    //}
    //catch (MissingResourceException e)
    //{
    //  StringBuffer b = new StringBuffer();
    //  try
    //  {
    //    b.append(RESOURCE_BUNDLE.getString("message.unknown"));
    //    b.append(": ");
    //  }
    //  catch (MissingResourceException e2)
    //  {
    //  }
    //  b.append(key);
    //  if (args != null && args.length > 0)
    //  {
    //    b.append("(");
    //    b.append(args[0]);
    //    for (int i = 1; i < args.length; i++)
    //    {
    //      b.append(", ");
    //      b.append(args[i]);
    //    }
    //    b.append(")");
    //  }
    //  return b.toString();
    //}
    //return MessageFormat.format(template, args);

    return (String) messages.get(key);
  }

  public static String get(String key, Object arg1)
  {
    String msg = (String) messages.get(key);
    return msg + "; " + arg1;
  }

  public static String get(String key, Object arg1, Object arg2)
  {
    String msg = (String) messages.get(key);
    return msg + "; " + arg1 + "; " + arg2;
  }

  public static String get(String key, Object arg1, Object arg2, Object arg3)
  {
    String msg = (String) messages.get(key);
    return msg + "; " + arg1 + "; " + arg2 + "; " + arg3;
  }

  public static String get(String key, Object[] args)
  {
    String msg = (String) messages.get(key);
    for (int i = 0; i < args.length; ++i)
    {
      msg += "; " + args[i].toString();
    }
    return msg;
  }
}
