/*
 * Copyright 2006, 2007 Odysseus Software GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * Additions/modifications to this source file by Oracle USA, Inc. 2007, 2008, 2009
 */
package de.odysseus.el.misc;


import java.util.Hashtable;
import java.util.Vector;

import oracle.adfnmc.el.ELException;
import oracle.adfnmc.java.lang.Comparable;
import oracle.adfnmc.util.Number;
import oracle.adfnmc.util.Utility;


public class BooleanOperations
{
  // Mobile: unsupported language feature
  //private final static Set<Class<? extends Number>> SIMPLE_INTEGER_TYPES = new HashSet<Class<? extends Number>>();

  // Mobile: unsupported language feature
  //private final static Set<Class<? extends Number>> SIMPLE_FLOAT_TYPES = new HashSet<Class<? extends Number>>();

  // Mobile: removed behavior
  // Mobile: unsupported type dependency
  //static {
  //  SIMPLE_INTEGER_TYPES.add(ClassObjectCache.getByteClass());
  //  SIMPLE_INTEGER_TYPES.add(ClassObjectCache.getShortClass());
  //  SIMPLE_INTEGER_TYPES.add(ClassObjectCache.getIntegerClass());
  //  SIMPLE_INTEGER_TYPES.add(ClassObjectCache.getLongClass());
  //  SIMPLE_FLOAT_TYPES.add(ClassObjectCache.getFloatClass());
  //  SIMPLE_FLOAT_TYPES.add(ClassObjectCache.getDoubleClass());
  //}

  // Mobile: unsupported type dependency
  //private static final BigDecimal toBigDecimal(Object value)
  //{
  //  return TypeConversions.coerceToNumber(value, BigDecimal.class);
  //}

  // Mobile: unsupported type dependency
  //private static final BigInteger toBigInteger(Object value)
  //{
  //  return TypeConversions.coerceToNumber(value, BigInteger.class);
  //}

  private static final long toLong(Object value)
  {
    // Mobile: substituted type
    //return TypeConversions.coerceToNumber(value, Long.class).longValue();
    return ((Long) TypeConversions.coerceToNumber(value, Utility.LONG_CLASS)).longValue();
  }

  private static final double toDouble(Object value)
  {
    // Mobile: substituted type
    //return TypeConversions.coerceToNumber(value, Double.class).doubleValue();
    return ((Double) TypeConversions.coerceToNumber(value, Utility.DOUBLE_CLASS)).doubleValue();
  }

  private static final String toString(Object value)
  {
    return TypeConversions.coerceToString(value);
  }

  private static final boolean toBoolean(Object value)
  {
    return TypeConversions.coerceToBoolean(value).booleanValue();
  }

  // Mobile: removed behavior
  // Mobile: unsupported language feature
  //@SuppressWarnings("unchecked")
  //private static final Enum toEnum(Object value, Class<? extends Enum> type)
  //{
  //  return TypeConversions.coerceToEnum(value, type);
  //}

  /**
   *
   * @param o1
   * @param o2
   * @return
   */
  // Mobile: unsupported language feature
  //@SuppressWarnings("unchecked")
  private static final boolean lt0(Object o1, Object o2)
  {
    Class t1 = o1.getClass();
    Class t2 = o2.getClass();

    // Mobile: unsupported type
    //if (BigDecimal.class.isAssignableFrom(t1) || BigDecimal.class.isAssignableFrom(t2))
    //{
    //  return toBigDecimal(o1).compareTo(toBigDecimal(o2)) < 0;
    //}

    // Mobile: substituted type
    //if (SIMPLE_FLOAT_TYPES.contains(t1) || SIMPLE_FLOAT_TYPES.contains(t2)) {
    if (Number.isObjectFloat(o1) || Number.isObjectFloat(o2))
    {
      return toDouble(o1) < toDouble(o2);
    }

    // Mobile: unsupported type
    //if (BigInteger.class.isAssignableFrom(t1) || BigInteger.class.isAssignableFrom(t2))
    //{
    //	return toBigInteger(o1).compareTo(toBigInteger(o2)) < 0;
    //}

    // Mobile: substituted type
    //if (SIMPLE_INTEGER_TYPES.contains(t1) || SIMPLE_INTEGER_TYPES.contains(t2)) {
    if (Number.isObjectIntegral(o1) || Number.isObjectIntegral(o2))
    {
      return toLong(o1) < toLong(o2);
    }

    // Mobile: substituted type
    if (t1 == Utility.STRING_CLASS || t2 == Utility.STRING_CLASS)
    {
      return toString(o1).compareTo(toString(o2)) < 0;
    }

    if (o1 instanceof Comparable)
    {
      return ((Comparable) o1).compareTo(o2) < 0;
    }
    if (o2 instanceof Comparable)
    {
      return ((Comparable) o2).compareTo(o1) > 0;
    }

    throw new ELException(LocalMessages.get("error.compare.types", o1.getClass(), o2.getClass()));
  }

  /**
   *
   * @param o1
   * @param o2
   * @return
   */
  // Mobile: unsupported language feature
  //@SuppressWarnings("unchecked")
  private static final boolean gt0(Object o1, Object o2)
  {
    Class t1 = o1.getClass();
    Class t2 = o2.getClass();

    // Mobile: unsupported type
    //if (BigDecimal.class.isAssignableFrom(t1) || BigDecimal.class.isAssignableFrom(t2))
    //{
    //  return toBigDecimal(o1).compareTo(toBigDecimal(o2)) > 0;
    //}

    // Mobile: substituted type
    //if (SIMPLE_FLOAT_TYPES.contains(t1) || SIMPLE_FLOAT_TYPES.contains(t2)) {
    if (Number.isObjectFloat(o1) || Number.isObjectFloat(o2))
    {
      return toDouble(o1) > toDouble(o2);
    }

    // Mobile: removed behavior
    // Mobile: unsupported type
    //if (BigInteger.class.isAssignableFrom(t1) || BigInteger.class.isAssignableFrom(t2))
    //{
    //  return toBigInteger(o1).compareTo(toBigInteger(o2)) > 0;
    //}

    // Mobile: substituted type
    //if (SIMPLE_INTEGER_TYPES.contains(t1) || SIMPLE_INTEGER_TYPES.contains(t2)) {
    if (Number.isObjectIntegral(o1) || Number.isObjectIntegral(o2))
    {
      return toLong(o1) > toLong(o2);
    }

    // Mobile: substituted type
    if (t1 == Utility.STRING_CLASS || t2 == Utility.STRING_CLASS)
    {
      return toString(o1).compareTo(toString(o2)) > 0;
    }

    if (o1 instanceof Comparable)
    {
      return ((Comparable) o1).compareTo(o2) > 0;
    }
    if (o2 instanceof Comparable)
    {
      return ((Comparable) o2).compareTo(o1) < 0;
    }

    throw new ELException(LocalMessages.get("error.compare.types", o1.getClass(), o2.getClass()));
  }

  /**
   * Convenience method to box boolean return values that are passed to values of Object type uses
   * the static TRUE and FALSE accessors to hopefully avoid allocating a new Boolean each time
   */
  // Mobile: added behavior
  public static final Boolean box(boolean value)
  {
    return value ? Boolean.TRUE: Boolean.FALSE;
  }

  public static final boolean lt(Object o1, Object o2)
  {
    if (o1 == o2)
    {
      return false;
    }
    if (o1 == null || o2 == null)
    {
      return false;
    }
    return lt0(o1, o2);
  }

  public static final boolean gt(Object o1, Object o2)
  {
    if (o1 == o2)
    {
      return false;
    }
    if (o1 == null || o2 == null)
    {
      return false;
    }
    return gt0(o1, o2);
  }

  public static final boolean ge(Object o1, Object o2)
  {
    if (o1 == o2)
    {
      return true;
    }
    if (o1 == null || o2 == null)
    {
      return false;
    }
    return !lt0(o1, o2);
  }

  public static final boolean le(Object o1, Object o2)
  {
    if (o1 == o2)
    {
      return true;
    }
    if (o1 == null || o2 == null)
    {
      return false;
    }
    return !gt0(o1, o2);
  }

  public static final boolean eq(Object o1, Object o2)
  {
    if (o1 == o2)
    {
      return true;
    }
    if (o1 == null || o2 == null)
    {
      return false;
    }
    Class t1 = o1.getClass();
    Class t2 = o2.getClass();

    // Mobile: unsupported type
    //if (BigDecimal.class.isAssignableFrom(t1) || BigDecimal.class.isAssignableFrom(t2))
    //{
    //  return toBigDecimal(o1).equals(toBigDecimal(o2));
    //}

    // Mobile: substituted type
    //if (SIMPLE_FLOAT_TYPES.contains(t1) || SIMPLE_FLOAT_TYPES.contains(t2)) {
    if (Number.isObjectFloat(o1) || Number.isObjectFloat(o2))
    {
      return toDouble(o1) == toDouble(o2);
    }

    // Mobile: unsupported type
    //if (BigInteger.class.isAssignableFrom(t1) || BigInteger.class.isAssignableFrom(t2))
    //{
    //  return toBigInteger(o1).equals(toBigInteger(o2));
    //}

    // Mobile: substituted type
    //if (SIMPLE_INTEGER_TYPES.contains(t1) || SIMPLE_INTEGER_TYPES.contains(t2)) {
    if (Number.isObjectIntegral(o1) || Number.isObjectIntegral(o2))
    {
      return toLong(o1) == toLong(o2);
    }

    // Mobile: substituted type
    if (t1 == Utility.BOOLEAN_CLASS || t2 == Utility.BOOLEAN_CLASS)
    {
      return toBoolean(o1) == toBoolean(o2);
    }

    // Mobile: removed behavior
    // Mobile: unsupported type
    //if (o1 instanceof Enum)
    //{
    //  return o1 == toEnum(o2, ((Enum)o1).getClass());
    //}
    //if (o2 instanceof Enum)
    //{
    //  return toEnum(o1, ((Enum)o2).getClass()) == o2;
    //}

    // Mobile: substituted type
    if (t1 == Utility.STRING_CLASS || t2 == Utility.STRING_CLASS)
    {
      return toString(o1).equals(toString(o2));
    }
    return o1.equals(o2);
  }

  public static final boolean ne(Object o1, Object o2)
  {
    return !eq(o1, o2);
  }

  public static final boolean and(Object o1, Object o2)
  {
    return toBoolean(o1) && toBoolean(o2);
  }

  public static final boolean or(Object o1, Object o2)
  {
    return toBoolean(o1) || toBoolean(o2);
  }

  public static final boolean not(Object o)
  {
    return !toBoolean(o);
  }

  public static final boolean empty(Object o)
  {
    if (o == null || "".equals(o))
    {
      return true;
    }
    if (o instanceof Object[])
    {
      return ((Object[]) o).length == 0;
    }
    if (o instanceof Hashtable)
    {
      return ((Hashtable) o).isEmpty();
    }

    // Mobile: removed behavior
    // Mobile: unsupported type
    //if (o instanceof Collection)
    //{
    //  return ((Collection)o).isEmpty();
    //}

    if (o instanceof Vector)
    {
      return ((Vector) o).isEmpty();
    }

    return false;
  }
}
