/*
 * Copyright 2006, 2007 Odysseus Software GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * Additions/modifications to this source file by Oracle USA, Inc. 2007, 2008, 2009
 */
package de.odysseus.el;


import de.odysseus.el.misc.LocalMessages;
import de.odysseus.el.misc.TypeConversions;

import oracle.adfnmc.el.ELContext;
import oracle.adfnmc.el.ELException;
import oracle.adfnmc.el.event.generic.ValueChangeListener;


/**
 * Object wrapper expression.
 *
 * @author Christoph Beck
 */
// Mobile: changed signature
//public final class ObjectValueExpression extends oracle.adfnmc.el.ValueExpression
public final class ObjectValueExpression
  implements oracle.adfnmc.el.ValueExpression
{
  // Mobile: unsupported language feature	
  //private static final long serialVersionUID = 1L;

  private final Object object;

  private Class type;


  /**
   * Wrap an object into a value expression.
   *
   * @param object
   *            the object to wrap
   * @param type
   *            the expected type this object will be coerced in {@link #getValue(ELContext)}.
   */
  public ObjectValueExpression(Object object, Class type)
  {
    super();

    this.object = object;
    this.type = type;

    if (type == null)
    {
      throw new NullPointerException(LocalMessages.get("error.value.notype"));
    }
  }


  /**
   *
   * @param listener
   */
  // Mobile: added behavior
  public void addValueChangeListener(ValueChangeListener listener)
  {
  }

  /**
   *
   * @param listener
   */
  // Mobile: added behavior
  public void removeValueChangeListener(ValueChangeListener listener)
  {
  }

  /**
   * Two object value expressions are equal if and only if their wrapped objects are equal.
   */
  public boolean equals(Object obj)
  {
    if (obj != null && obj.getClass() == getClass())
    {
      ObjectValueExpression other = (ObjectValueExpression) obj;
      if (type != other.type)
      {
        return false;
      }
      return object == other.object || object != null && object.equals(other.object);
    }
    return false;
  }

  public int hashCode()
  {
    return object == null ? 0: object.hashCode();
  }

  public Object getValue()
  {
    return this.getValue(ELContext.getInstance());
  }

  /**
   * Answer the wrapped object, coerced to the expected type.
   */
  public Object getValue(ELContext context)
  {
    Object value = TypeConversions.coerceToType(object, type);
    return value;
  }

  /**
   * Answer <code>null</code>.
   */
  public String getExpressionString()
  {
    return null;
  }

  /**
   * Answer <code>false</code>.
   */
  public boolean isLiteralText()
  {
    return false;
  }

  /**
   * Answer <code>null</code>.
   */
  public Class getType(ELContext context)
  {
    return null;
  }

  public boolean isReadOnly()
  {
    return this.isReadOnly(ELContext.getInstance());
  }

  /**
   * Answer <code>true</code>.
   */
  public boolean isReadOnly(ELContext context)
  {
    return true;
  }

  public void setValue(Object value)
  {
    this.setValue(ELContext.getInstance(), value);
  }

  /**
   * Throw an exception.
   */
  public void setValue(ELContext context, Object value)
  {
    throw new ELException(LocalMessages.get("error.value.set.rvalue"));
  }

  /**
   * Returns true if the value resolved by this expression is secret and should not be displayed or logged
   */
  public boolean isValueSecret()
  {
    return false;
  }
  
  /**
   * Set to true if the value resolved by this expression is secret and should not be displayed or logged
   */
  public void setValueSecret(boolean valueIsSecret)
  {
  }

  public String toString()
  {
    return "ValueExpression(" + object + ")";
  }

  public Class getExpectedType()
  {
    return type;
  }

  public void setExpectedType(Class type)
  {
    this.type = type;
  }
}
