/*
 * Copyright 2006, 2007 Odysseus Software GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * Additions/modifications to this source file by Oracle USA, Inc. 2007, 2008, 2009
 */
package de.odysseus.el;


import de.odysseus.el.misc.TypeConversionsImpl;
import de.odysseus.el.tree.TreeStore;
import de.odysseus.el.tree.impl.Builder;
import de.odysseus.el.tree.impl.Cache;

import oracle.adfnmc.el.ELContext;
import oracle.adfnmc.el.ExpressionFactory;
import oracle.adfnmc.el.MethodExpression;
import oracle.adfnmc.el.ValueExpression;


/**
 * Expression factory implementation.
 *
 * This class is also used as an EL "service provider". The <em>JUEL</em> jar files specify this
 * class as their expression factory implementation in
 * <code>META-INF/services/javax.el.ExpressionFactory</code>. Calling
 * {@link ExpressionFactory#getExpressionFactory()} will then return an instance of this class,
 * configured as described below.
 *
 * The default constructor loads properties from resources
 * <ol>
 * <li> <code>JAVA_HOME/lib/el.properties</code> - If this file exists and if it contains property
 * <code>javax.el.ExpressionFactory</code> whose value is the name of this class, these properties
 * are taken as default properties. </li>
 * <li> <code>el.properties</code> on your classpath. These properties override the properties
 * from <code>JAVA_HOME/lib/el.properties</code>. </li>
 * </ol>
 * There's also a constructor to explicitly pass in an instance of {@link Properties}. Having this,
 * the following properties are read:
 * <ul>
 * <li> <code>javax.el.cacheSize</code> - cache size (int, default is 1000) </li>
 * <li> <code>javax.el.methodInvocations</code> - allow method invocations as in
 * <code>${foo.bar(baz)}</code> (boolean, default is <code>false</code>). </li>
 * <li> <code>javax.el.nullProperties</code> - resolve <code>null</code> properties as in
 * <code>${foo[null]}</code> (boolean, default is <code>false</code>). </li>
 * </ul>
 *
 * @author Christoph Beck
 */
public class ExpressionFactoryImpl
  extends oracle.adfnmc.el.ExpressionFactory
{
  private final TreeStore store;


  /**
   * Create a new expression factory using the default parser and tree cache implementations. The
   * builder and cache are configured from <code>el.properties</code> (see above). The maximum
   * cache size will be 100 unless overridden in <code>el.properties</code>.
   */
  public ExpressionFactoryImpl()
  {
    // Mobile: removed behavior
    // Mobile: unsupported type dependency
    //store = createTreeStore(1000, loadProperties("el.properties"));
    store = createTreeStore(100);
  }

  // Mobile: removed behavior
  // Mobile: unsupported type dependency
  ///**
  // * Create a new expression factory using the default builder and cache implementations. The
  // * builder and cache are configured using the specified properties. The maximum cache size will
  // * be 1000 unless overridden by property <code>javax.el.cacheSize</code>.
  // *
  // * @param properties
  // *            used to initialize builder and cache (may be <code>null</code>)
  // */
  //public ExpressionFactoryImpl(Properties properties)
  //{
  //  store = createTreeStore(1000, properties);
  //}

  /**
   * Create a new expression factory.
   *
   * @param store
   *            the tree store used to parse and cache parse trees.
   */
  public ExpressionFactoryImpl(TreeStore store)
  {
    this.store = store;
  }

  // Mobile: removed behavior
  // Mobile: unsupported type dependency
  //private Properties loadDefaultProperties()
  //{
  //  String home = System.getProperty("java.home");
  //  String path = home + File.separator + "lib" + File.separator + "el.properties";
  //  File file = new File(path);
  //  if (file.exists())
  //  {
  //    Properties properties = new Properties();
  //    InputStream input = null;
  //    try
  //    {
  //      properties.load(input = new FileInputStream(file));
  //    }
  //    catch (IOException e)
  //    {
  //      throw new ELException("Cannot read default EL properties", e);
  //    }
  //    finally
  //    {
  //      try
  //      {
  //        input.close();
  //      }
  //      catch (IOException e)
  //      {
  //        // ignore... } } String clazz =
  //        properties.getProperty("javax.el.ExpressionFactory");
  //        if (getClass().getName().equals(clazz))
  //        {
  //          return properties;
  //        }
  //      }
  //      return null;
  //    }
  //  }
  //}

  // Mobile: removed behavior
  // Mobile: unsupported type dependency
  //private Properties loadProperties(String path)
  //{
  //  Properties properties = new Properties(loadDefaultProperties());
  //
  //  // try to find and load properties InputStream input = null;
  //  try
  //  {
  //    input = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
  //  }
  //  catch (SecurityException e)
  //  {
  //    input = ClassLoader.getSystemResourceAsStream(path);
  //  }
  //  if (input != null)
  //  {
  //    try
  //    {
  //      properties.load(input);
  //    }
  //    catch (IOException e)
  //    {
  //      throw new ELException("Cannot read EL properties", e);
  //    }
  //    finally
  //    {
  //      try
  //      {
  //        input.close();
  //      }
  //      catch (IOException e)
  //      {
  //        // ignore...
  //      }
  //    }
  //  }
  //  return properties;
  //}

  /**
   * Create the factory's tree store. This implementation creates a new tree store using the
   * default builder and cache implementations. The builder and cache are configured using the
   * specified properties. The maximum cache size will be as specified unless overridden by
   * property <code>javax.el.cacheSize</code>.
   */
  // Mobile: changed signature
  // Mobile: unsupported type dependency
  //protected TreeStore createTreeStore(int defaultCacheSize, Properties properties)
  protected TreeStore createTreeStore(int defaultCacheSize)
  {
    // Mobile: removed behavior
    // Mobile: unsupported type dependency
    //// create builder
    //
    //EnumSet<Builder.Feature> features = EnumSet.noneOf(Builder.Feature.class);
    //
    //if (properties != null)
    //{
    //  if (Boolean.valueOf(properties.getProperty("javax.el.methodInvocations")))
    //  {
    //    features.add(Builder.Feature.METHOD_INVOCATIONS);
    //  }
    //  if (Boolean.valueOf(properties.getProperty("javax.el.nullProperties")))
    //  {
    //    features.add(Builder.Feature.NULL_PROPERTIES);
    //  }
    //}
    //
    //Builder builder = new Builder(features.toArray(new Builder.Feature[features.size()]));

    // create builder
    // Mobile: changed behavior - Builder ignores Features
    Builder builder = new Builder(null);

    // create cache
    int cacheSize = defaultCacheSize;

    // Mobile: removed behavior
    // Mobile: unsupported type dependency
    //if (properties != null && properties.containsKey("javax.el.cacheSize"))
    //{
    //  try
    //  {
    //    cacheSize = Integer.parseInt(properties.getProperty("javax.el.cacheSize"));
    //  }
    //  catch (NumberFormatException e)
    //  {
    //    throw new ELException("Cannot parse EL property javax.el.cacheSize", e);
    //  }
    //}

    Cache cache = cacheSize > 0 ? new Cache(cacheSize): null;

    return new TreeStore(builder, cache);
  }

  public final Object coerceToType(Object obj, Class targetType)
  {
    Object value = TypeConversionsImpl.coerceToType(obj, targetType);
    return value;
  }

  /**
   *
   * @param instance
   * @param expectedType
   * @return
   */
  // Mobile: changed signature
  //public final ObjectValueExpression createValueExpression(Object instance, Class expectedType)
  public final ValueExpression createValueExpression(Object instance, Class expectedType)
  {
    return new ObjectValueExpression(instance, expectedType);
  }

  /**
   *
   * @param context
   * @param expression
   * @param expectedType
   * @return
   */
  // Mobile: changed signature
  //public final TreeValueExpression createValueExpression(ELContext context, String expression, Class expectedType)
  public final ValueExpression createValueExpression(ELContext context, String expression, Class expectedType)
  {
    return new TreeValueExpression(store, context.getFunctionMapper(), context.getVariableMapper(), expression,
                                   expectedType);
  }

  // Mobile: removed behavior
  // Mobile: unsupported type dependency
  // Mobile: changed signature
  //public final TreeMethodExpression createMethodExpression(ELContext context, String expression, Class expectedReturnType, Class[] expectedParamTypes)
  public final MethodExpression createMethodExpression(ELContext context, String expression, Class expectedReturnType,
                                                     Class[] expectedParamTypes) 
  {
    return new TreeMethodExpression(store, context.getFunctionMapper(), context.getVariableMapper(), expression,
                                    expectedReturnType, expectedParamTypes);
  }
}
