package oracle.adfnmc.util.eventing;


/**
 * <p>
 * The root class from which all event state objects shall be derived.
 * <p>
 * All Events are constructed with a reference to the object, the "source", that is logically
 * deemed to be the object upon which the Event in question initially occurred upon.
 *
 * Adapted from JDK source code
 */
// Mobile: added type
public class EventObject
{
  private static final long serialVersionUID = 5516075349620653480L;

  /**
   * The object on which the Event initially occurred.
   */
  protected transient Object source;

  /**
   * Constructs a prototypical Event.
   *
   * @param source
   *          The object on which the Event initially occurred.
   * @exception IllegalArgumentException
   *              if source is null.
   */
  public EventObject(Object source)
  {
    if (source == null)
      throw new IllegalArgumentException("null source");

    this.source = source;
  }

  /**
   * The object on which the Event initially occurred.
   *
   * @return The object on which the Event initially occurred.
   */
  public Object getSource()
  {
    return source;
  }

  /**
   * Returns a String representation of this EventObject.
   *
   * @return A a String representation of this EventObject.
   */
  public String toString()
  {
    return getClass().getName() + "[source=" + source + "]";
  }
}
