package oracle.adfnmc.util;


/**
 * The JavaSE 'Number' class is the abstract supertype of a many numeric types. Since
 * we can't substitute the base classes for these, instead just have this class encapsulate the
 * numeric types.
 */
// Mobile: added type
public class Number
{
  public static final Class CLASS_INSTANCE = Number.class;

  private Object _value = null;

  public static boolean isObjectFloat(Object value)
  {
    if ((value instanceof Float) || (value instanceof Double))
    {
      return true;
    }

    if (value instanceof Number)
    {
      return isObjectFloat(((Number) value).getInnerValue());
    }

    return false;
  }

  public static boolean isObjectIntegral(Object value)
  {
    if ((value instanceof Byte) || (value instanceof Short) || (value instanceof Integer) || (value instanceof Long))
    {
      return true;
    }

    if (value instanceof Number)
    {
      return isObjectIntegral(((Number) value).getInnerValue());
    }

    return false;
  }

  public static boolean isObjectNumeric(Object value)
  {
    return isObjectIntegral(value) || isObjectFloat(value);
  }

  public static boolean isTypeIntegral(Class type)
  {
    if (type == null)
    {
      return false;
    }

    if (type.equals(Utility.BYTE_CLASS) || type.equals(Utility.SHORT_CLASS) || type.equals(Utility.INTEGER_CLASS) ||
        type.equals(Utility.LONG_CLASS))
    {
      return true;
    }

    return false;
  }

  public static boolean isTypeFloat(Class type)
  {
    if (type == null)
    {
      return false;
    }

    if (type.equals(Utility.FLOAT_CLASS) || type.equals(Utility.DOUBLE_CLASS) || type.equals(Utility.NUMBER_CLASS))
    {
      return true;
    }

    return false;
  }

  public static boolean isTypeNumeric(Class type)
  {
    return isTypeIntegral(type) || isTypeFloat(type);
  }

  public static Byte box(byte value)
  {
    return new Byte(value);
  }

  public static Long box(long value)
  {
    return new Long(value);
  }

  public static Double box(double value)
  {
    return new Double(value);
  }

  public Number(byte value)
  {
    _value = new Byte(value);
  }

  public Number(short value)
  {
    _value = new Short(value);
  }

  public Number(int value)
  {
    _value = new Integer(value);
  }

  public Number(long value)
  {
    _value = new Long(value);
  }

  public Number(float value)
  {
    _value = new Float(value);
  }

  public Number(double value)
  {
    _value = new Double(value);
  }

  public Number(Object value)
  {
    // loop through and make sure we aren't wrapping a number in a number
    while (value instanceof Number)
    {
      value = ((Number) value).getInnerValue();
    }

    if (value instanceof String)
    {
      _value = setValueFromString((String) value);
    }
    else if (!(Number.isObjectNumeric(value)))
    {
      throw new RuntimeException(value.toString() + " is not numeric");
    }
    _value = value;
  }

  private static Object setValueFromString(String value)
  {
    if (value != null && value.indexOf('.') == -1)
      return new Long(Long.parseLong(value));
    return Double.valueOf(value);
  }

  public Number(String value)
  {
    _value = setValueFromString(value);
  }

  public Number(String value, Class clazz)
  {
    if (clazz.equals(Utility.BYTE_CLASS))
      _value = new Byte(Byte.parseByte(value));
    else if (clazz.equals(Utility.DOUBLE_CLASS))
      _value = Double.valueOf(value);
    else if (clazz.equals(Utility.FLOAT_CLASS))
      _value = Float.valueOf(value);
    else if (clazz.equals(Utility.INTEGER_CLASS))
      _value = Integer.valueOf(value);
    else if (clazz.equals(Utility.LONG_CLASS))
      _value = new Long(Long.parseLong(value));
    else if (clazz.equals(Utility.SHORT_CLASS))
      _value = new Short(Short.parseShort(value));
    else
    {
      _value = Double.valueOf(value);
    }
  }

  public Class getInnerType()
  {
    return _value.getClass();
  }

  public Object getInnerValue()
  {
    return _value;
  }

  protected boolean isFloat()
  {
    if ((_value instanceof Float) || (_value instanceof Double))
    {
      return true;
    }
    return false;
  }

  protected boolean isIntegral()
  {
    if ((_value instanceof Byte) || (_value instanceof Short) || (_value instanceof Integer) ||
        (_value instanceof Long))
    {
      return true;
    }
    return false;
  }

  public byte byteValue()
  {
    byte val = 0;

    if (_value instanceof Byte)
    {
      val = ((Byte) _value).byteValue();
    }
    else if (_value instanceof Short)
    {
      val = (byte) ((Short) _value).shortValue();
    }
    else if (_value instanceof Integer)
    {
      val = ((Integer) _value).byteValue();
    }
    else if (_value instanceof Long)
    {
      val = (byte) ((Long) _value).longValue();
    }
    else if (_value instanceof Float)
    {
      val = ((Float) _value).byteValue();
    }
    else if (_value instanceof Double)
    {
      val = ((Double) _value).byteValue();
    }
    else
    {
      val = ((Number) _value).byteValue();
    }
    return val;
  }

  public short shortValue()
  {
    short val = 0;

    if (_value instanceof Byte)
    {
      val = ((Byte) _value).byteValue();
    }
    else if (_value instanceof Short)
    {
      val = ((Short) _value).shortValue();
    }
    else if (_value instanceof Integer)
    {
      val = ((Integer) _value).shortValue();
    }
    else if (_value instanceof Long)
    {
      val = (short) ((Long) _value).longValue();
    }
    else if (_value instanceof Float)
    {
      val = ((Float) _value).shortValue();
    }
    else if (_value instanceof Double)
    {
      val = ((Double) _value).shortValue();
    }
    else
    {
      val = ((Number) _value).shortValue();
    }
    return val;
  }

  public int intValue()
  {
    int val = 0;

    if (_value instanceof Byte)
    {
      val = ((Byte) _value).byteValue();
    }
    else if (_value instanceof Short)
    {
      val = ((Short) _value).shortValue();
    }
    else if (_value instanceof Integer)
    {
      val = ((Integer) _value).intValue();
    }
    else if (_value instanceof Long)
    {
      val = (int) ((Long) _value).longValue();
    }
    else if (_value instanceof Float)
    {
      val = ((Float) _value).intValue();
    }
    else if (_value instanceof Double)
    {
      val = ((Double) _value).intValue();
    }
    else
    {
      val = ((Number) _value).intValue();
    }
    return val;
  }

  public long longValue()
  {
    long val = 0;

    if (_value instanceof Byte)
    {
      val = ((Byte) _value).byteValue();
    }
    else if (_value instanceof Short)
    {
      val = ((Short) _value).shortValue();
    }
    else if (_value instanceof Integer)
    {
      val = ((Integer) _value).longValue();
    }
    else if (_value instanceof Long)
    {
      val = ((Long) _value).longValue();
    }
    else if (_value instanceof Float)
    {
      val = ((Float) _value).longValue();
    }
    else if (_value instanceof Double)
    {
      val = ((Double) _value).longValue();
    }
    else if (_value instanceof Double)
    {
      val = ((Double) _value).longValue();
    }
    else
    {
      val = ((Number) _value).longValue();
    }
    return val;
  }

  public float floatValue()
  {
    float val = 0;

    if (_value instanceof Byte)
    {
      val = ((Byte) _value).byteValue();
    }
    else if (_value instanceof Short)
    {
      val = ((Short) _value).shortValue();
    }
    else if (_value instanceof Integer)
    {
      val = ((Integer) _value).floatValue();
    }
    else if (_value instanceof Long)
    {
      val = ((Long) _value).floatValue();
    }
    else if (_value instanceof Float)
    {
      val = ((Float) _value).floatValue();
    }
    else if (_value instanceof Double)
    {
      val = ((Double) _value).floatValue();
    }
    else
    {
      val = ((Number) _value).floatValue();
    }
    return val;
  }

  public double doubleValue()
  {
    double val = 0;

    if (_value instanceof Byte)
    {
      val = ((Byte) _value).byteValue();
    }
    else if (_value instanceof Short)
    {
      val = ((Short) _value).shortValue();
    }
    else if (_value instanceof Integer)
    {
      val = ((Integer) _value).doubleValue();
    }
    else if (_value instanceof Long)
    {
      val = ((Long) _value).doubleValue();
    }
    else if (_value instanceof Float)
    {
      val = ((Float) _value).floatValue();
    }
    else if (_value instanceof Double)
    {
      val = ((Double) _value).doubleValue();
    }
    else
    {
      val = ((Number) _value).doubleValue();
    }
    return val;
  }

  public String toString()
  {
    if (_value == null)
      return null;
    else
      return _value.toString();
  }
}
