package oracle.adfnmc.java.io;


import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;

// Mobile: added type
public class PrintWriter
  extends Writer
{
  public static final Class CLASS_INSTANCE = PrintWriter.class;

  // private final PrintStream _stream;
  private final java.io.Writer _writer;
  private final boolean _autoFlush;
  private static final String LINE_SEPARATOR = "\r\n";

  /**
   * indicates whether or not this PrintWriter has incurred an error.
   */
  private boolean ioError;

  public PrintWriter(OutputStream stream)
  {
    // _stream = new PrintStream(stream);
    this(stream, false);
  }

  public PrintWriter(OutputStream stream, boolean autoFlush)
  {
    // _stream = new PrintStream(stream);
    _writer = new OutputStreamWriter(new PrintStream(stream));
    _autoFlush = autoFlush;
  }

  /**
   * Constructs a new PrintWriter on the Writer <code>wr</code>. All writes to the target can now take place through
   * this PrintWriter. By default, the PrintWriter is set to not autoflush when println() is called.
   *
   * @param wr
   *          the Writer to provide convenience methods on.
   */
  public PrintWriter(java.io.Writer wr)
  {
    this(wr, false);
  }

  /**
   * Constructs a new PrintWriter on the given writer. All writes to the target can now take place through this
   * PrintWriter. By default, the PrintWriter is set to not autoflush when println() is called.
   *
   * @param wr
   *          the Writer to provide convenience methods on.
   * @param autoflush
   *          whether to flush when println() is called.
   */
  public PrintWriter(java.io.Writer wr, boolean autoflush)
  {
    _writer = wr;
    this._autoFlush = autoflush;
  }

  public void close()
  {
    // _stream.close();
    try
    {
      _writer.close();
    }
    catch (IOException e)
    {
      setError();
    }
  }

  public void flush()
  {
    // _stream.flush();
    try
    {
      _writer.flush();
    }
    catch (IOException e)
    {
      setError();
    }
  }

  public void write(char[] buffer, int offset, int length)
  {
    // String msg = new String(buffer, offset, length);
    // this.print(msg);
    try
    {
      _writer.write(buffer, offset, length);
    }
    catch (IOException e)
    {
      setError();
    }
  }

  public void write(String str)
  {
    write(str.toCharArray());
  }

  public void write(char[] buf)
  {
    write(buf, 0, buf.length);
  }

  public void print(String x)
  {
    // _stream.print(x);
    if (x == null)
      this.write("null".toCharArray());
    else
      this.write(x.toCharArray());
  }

  /**
   * Prints the String representation of the character array parameter <code>charArray</code> to the target Writer.
   *
   * @param charArray
   *          the character array to print on this Writer.
   */
  public void print(char[] charArray)
  {
    print(new String(charArray, 0, charArray.length));
  }

  public void println(String x)
  {
    // _stream.println(x);
    // if (_autoFlush)
    // _stream.flush();
    this.print(x);
    this.print(LINE_SEPARATOR);
    if (_autoFlush)
      this.flush();
  }

  public void println()
  {
    // _stream.println();
    // if (_autoFlush)
    // _stream.flush();
    this.print(LINE_SEPARATOR);
  }

  protected void setError()
  {
    ioError = true;
  }

  public boolean checkError()
  {
    flush();
    return ioError;
  }

  public void print(boolean bool)
  {
    print(String.valueOf(bool));
  }

  public void print(Object obj)
  {
    print(obj == null ? "null": obj.toString());
  }

  /**
   * Prints the String representation of the <code>double</code> parameter <code>dnum</code> to the target Writer.
   *
   * @param dnum
   *          the <code>double</code> to print on this Writer.
   */
  public void print(double dnum)
  {
    print(String.valueOf(dnum));
  }

  /**
   * Prints the String representation of the <code>float</code> parameter <code>fnum</code> to the target Writer.
   *
   * @param fnum
   *          the <code>float</code> to print on this Writer.
   */
  public void print(float fnum)
  {
    print(String.valueOf(fnum));
  }

  /**
   * Prints the String representation of the <code>int</code> parameter <code>inum</code> to the target Writer.
   *
   * @param inum
   *          the <code>int</code> to print on this Writer.
   */
  public void print(int inum)
  {
    print(String.valueOf(inum));
  }

  /**
   * Prints the String representation of the <code>long</code> parameter <code>lnum</code> to the target Writer.
   *
   * @param lnum
   *          the <code>long</code> to print on this Writer.
   */
  public void print(long lnum)
  {
    print(String.valueOf(lnum));
  }

  /**
   * Prints the String representation of the character array parameter <code>charArray</code> to the target Writer
   * followed by the System property <code>"line.separator"</code>.
   *
   * @param charArray
   *          the character array to print on this Writer.
   */
  public void println(char[] charArray)
  {
    println(new String(charArray, 0, charArray.length));
  }

  /**
   * Prints the String representation of the character parameter <code>ch</code> to the target Writer.
   *
   * @param ch
   *          the character to print on this Writer.
   */
  public void print(char ch)
  {
    print(String.valueOf(ch));
  }

  public void write(int oneChar)
  {
    char[] charArray = new char[1];
    charArray[0] = (char) oneChar;
    this.write(charArray);
  }

  /**
   * Prints the String representation of the character parameter <code>ch</code> to the target Writer followed by the
   * System property <code>"line.separator"</code>.
   *
   * @param ch
   *          the character to print on this Writer.
   */
  public void println(char ch)
  {
    println(String.valueOf(ch));
  }

  /**
   * Prints the String representation of the <code>double</code> parameter <code>dnum</code> to the target Writer
   * followed by the System property <code>"line.separator"</code>.
   *
   * @param dnum
   *          the double to print on this Writer.
   */
  public void println(double dnum)
  {
    println(String.valueOf(dnum));
  }

  /**
   * Prints the String representation of the <code>float</code> parameter <code>fnum</code> to the target Writer
   * followed by the System property <code>"line.separator"</code>.
   *
   * @param fnum
   *          the float to print on this Writer.
   */
  public void println(float fnum)
  {
    println(String.valueOf(fnum));
  }

  /**
   * Prints the String representation of the <code>int</code> parameter <code>inum</code> to the target Writer followed
   * by the System property <code>"line.separator"</code>.
   *
   * @param inum
   *          the int to print on this Writer.
   */
  public void println(int inum)
  {
    println(String.valueOf(inum));
  }

  /**
   * Prints the String representation of the <code>long</code> parameter <code>lnum</code> to the target Writer followed
   * by the System property <code>"line.separator"</code>.
   *
   * @param lnum
   *          the long to print on this Writer.
   */
  public void println(long lnum)
  {
    println(String.valueOf(lnum));
  }

  /**
   * Prints the String representation of the <code>Object</code> parameter <code>obj</code> to the target Writer
   * followed by the System property <code>"line.separator"</code>.
   *
   * @param obj
   *          the <code>Object</code> to print on this Writer.
   */
  public void println(Object obj)
  {
    println(String.valueOf(obj));
  }

  /**
   * Prints the String representation of the <code>boolean</code> parameter <code>bool</code> to the target Writer
   * followed by the System property <code>"line.separator"</code>.
   *
   * @param bool
   *          the boolean to print on this Writer.
   */
  public void println(boolean bool)
  {
    println(String.valueOf(bool));
  }

  /**
   * Writes <code>count</code> characters from the String <code>str</code> starting at <code>offset</code> to this
   * Writer.
   *
   * @param str
   *          the non-null String containing the characters to write.
   * @param offset
   *          where in <code>str</code> to get chars from.
   * @param count
   *          how many characters to write.
   *
   * @throws ArrayIndexOutOfBoundsException
   *           If offset or count are outside of bounds.
   */
  public void write(String str, int offset, int count)
  {
    write(str.substring(offset, offset + count).toCharArray());
  }
}
