/*
 * @(#)CredentialExpiredException.java	1.16 06/08/10
 *
 * Copyright (c) 1990, 2011, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package javax.security.auth.login;

/**
 * Signals that a <code>Credential</code> has expired.
 * 
 * <p> This exception is thrown by LoginModules when they determine
 * that a <code>Credential</code> has expired.
 * For example, a <code>LoginModule</code> authenticating a user
 * in its <code>login</code> method may determine that the user's
 * password, although entered correctly, has expired.  In this case
 * the <code>LoginModule</code> throws this exception to notify
 * the application.  The application can then take the appropriate
 * steps to assist the user in updating the password.
 *
 * @version 1.16, 08/10/06
 */
public class CredentialExpiredException extends LoginException {
    
    /**
     * Constructs a CredentialExpiredException with no detail message. A detail
     * message is a String that describes this particular exception.
     */
    public CredentialExpiredException() {}
    
    /**
     * Constructs a CredentialExpiredException with the specified detail
     * message.  A detail message is a String that describes this particular
     * exception.
     *
     * <p>
     *
     * @param msg the detail message.  
     */
    public CredentialExpiredException(String msg) {}
}
