/*
 *
 * @(#)StringCharacterIterator.java	1.24 06/10/03
 *
 * Portions Copyright (c) 2000, 2011, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * (C) Copyright Taligent, Inc. 1996, 1997 - All Rights Reserved
 * (C) Copyright IBM Corp. 1996 - 1998 - All Rights Reserved
 *
 * The original version of this source code and documentation
 * is copyrighted and owned by Taligent, Inc., a wholly-owned
 * subsidiary of IBM. These materials are provided under terms
 * of a License Agreement between Taligent and Sun. This technology
 * is protected by multiple US and International patents.
 *
 * This notice and attribution to Taligent may not be removed.
 * Taligent is a registered trademark of Taligent, Inc.
 *
 */

package java.text;

/**
 * <code>StringCharacterIterator</code> implements the
 * <code>CharacterIterater</code> protocol for a <code>String</code>.
 * The <code>StringCharacterIterator</code> class iterates over the
 * entire <code>String</code>.
 *
 * @see CharacterIterator
 */
public final class StringCharacterIterator implements CharacterIterator {
    
    
    
    
    
    /**
     * Constructs an iterator with an initial index of 0.
     */
    public StringCharacterIterator(String text) {}
    
    /**
     * Constructs an iterator with the specified initial index.
     *
     * @param  text   The String to be iterated over
     * @param  pos    Initial iterator position
     */
    public StringCharacterIterator(String text, int pos) {}
    
    /**
     * Constructs an iterator over the given range of the given string, with the
     * index set at the specified position.
     *
     * @param  text   The String to be iterated over
     * @param  begin  Index of the first character
     * @param  end    Index of the character following the last character
     * @param  pos    Initial iterator position
     */
    public StringCharacterIterator(String text, int begin, int end, int pos) {}
    
    /**
     * Reset this iterator to point to a new string.  This package-visible
     * method is used by other java.text classes that want to avoid allocating
     * new StringCharacterIterator objects every time their setText method
     * is called.
     *
     * @param  text   The String to be iterated over
     * @since 1.2
     */
    public void setText(String text) {
        return ;
    }
    
    /**
     * Implements CharacterIterator.first() for String.
     * @see CharacterIterator#first
     */
    public char first() {
        return '0';
    }
    
    /**
     * Implements CharacterIterator.last() for String.
     * @see CharacterIterator#last
     */
    public char last() {
        return '0';
    }
    
    /**
     * Implements CharacterIterator.setIndex() for String.
     * @see CharacterIterator#setIndex
     */
    public char setIndex(int p) {
        return '0';
    }
    
    /**
     * Implements CharacterIterator.current() for String.
     * @see CharacterIterator#current
     */
    public char current() {
        return '0';
    }
    
    /**
     * Implements CharacterIterator.next() for String.
     * @see CharacterIterator#next
     */
    public char next() {
        return '0';
    }
    
    /**
     * Implements CharacterIterator.previous() for String.
     * @see CharacterIterator#previous
     */
    public char previous() {
        return '0';
    }
    
    /**
     * Implements CharacterIterator.getBeginIndex() for String.
     * @see CharacterIterator#getBeginIndex
     */
    public int getBeginIndex() {
        return 0;
    }
    
    /**
     * Implements CharacterIterator.getEndIndex() for String.
     * @see CharacterIterator#getEndIndex
     */
    public int getEndIndex() {
        return 0;
    }
    
    /**
     * Implements CharacterIterator.getIndex() for String.
     * @see CharacterIterator#getIndex
     */
    public int getIndex() {
        return 0;
    }
    
    /**
     * Compares the equality of two StringCharacterIterator objects.
     * @param obj the StringCharacterIterator object to be compared with.
     * @return true if the given obj is the same as this
     * StringCharacterIterator object; false otherwise.
     */
    public boolean equals(Object obj) {
        return false;
    }
    
    /**
     * Computes a hashcode for this iterator.
     * @return A hash code
     */
    public int hashCode() {
        return 0;
    }
    
    /**
     * Creates a copy of this iterator.
     * @return A copy of this
     */
    public Object clone() {
        return null;
    }
}
