/*
 * Copyright 2003 Sun Microsystems, Inc. All rights reserved.
 * SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * @(#)Time.java	1.8 03/10/21
 */

package java.sql;

import java.text.*;
import java.util.GregorianCalendar;

/**
 * <P>A thin wrapper around the <code>java.util.Date</code> class that allows the JDBC
 * API to identify this as an SQL <code>TIME</code> value. The <code>Time</code>
 * class adds formatting and
 * parsing operations to support the JDBC escape syntax for time
 * values. 
 * <p>The date components should be set to the "zero epoch"
 * value of January 1, 1970 and should not be accessed. 
 */
public class Time extends java.util.Date {
    
    /**
     * Constructs a <code>Time</code> object using a milliseconds time value.
     *
     * @param time milliseconds since January 1, 1970, 00:00:00 GMT;
     *             a negative number is milliseconds before
     *               January 1, 1970, 00:00:00 GMT
     */
    public Time(long time) {}
    
    /**
     * Sets a <code>Time</code> object using a milliseconds time value.
     *
     * @param time milliseconds since January 1, 1970, 00:00:00 GMT;
     *             a negative number is milliseconds before
     *               January 1, 1970, 00:00:00 GMT
     */
    public void setTime(long time) {
        return ;
    }
    
    /**
     * Converts a string in JDBC time escape format to a <code>Time</code> value.
     *
     * @param s time in format "hh:mm:ss"
     * @return a corresponding <code>Time</code> object
     * @overrides java.util.Date.valueOf
     */
    public static Time valueOf(String s) {
        return null;
    }
    
    /**
     * Formats a time in JDBC time escape format.  
     *
     * @return a <code>String</code> in hh:mm:ss format
     * @overrides java.util.Date.toString
     */
    public String toString() {
        return null;
    }
    
}
