/*
 * @(#)RSAKeyGenParameterSpec.java	1.11 06/10/10
 *
 * Copyright (c) 1990, 2011, Oracle and/or its affiliates. All rights reserved.  
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */

package java.security.spec;

import java.math.BigInteger;
import java.security.spec.AlgorithmParameterSpec;

/**
 * This class specifies the set of parameters used to generate an RSA
 * key pair.
 * 
 * @author Jan Luehe
 * @version 1.5 02/02/00
 *
 * @see java.security.KeyPairGenerator#initialize(java.security.spec.AlgorithmParameterSpec)
 *
 * @since 1.3
 */
public class RSAKeyGenParameterSpec implements AlgorithmParameterSpec {
    
    
    
    /**
     * The public-exponent value F0 = 3.
     */
    public static final BigInteger F0;
    
    /**
     * The public exponent-value F4 = 65537.
     */
    public static final BigInteger F4;
    
    /**
     * Constructs a new <code>RSAParameterSpec</code> object from the
     * given keysize and public-exponent value.
     *
     * @param keysize the modulus size (specified in number of bits)
     * @param publicExponent the public exponent
     */
    public RSAKeyGenParameterSpec(int keysize, BigInteger publicExponent) {}
    
    /**
     * Returns the keysize.
     *
     * @return the keysize.
     */
    public int getKeysize() {
        return 0;
    }
    
    /**
     * Returns the public-exponent value.
     *
     * @return the public-exponent value.
     */
    public BigInteger getPublicExponent() {
        return null;
    }
}
