/*
 * @(#)UnsupportedClassVersionError.java	1.14 06/10/10
 *
 * Copyright (c) 1990, 2011, Oracle and/or its affiliates. All rights reserved.  
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */

package java.lang;

/**
 * Thrown when the Java Virtual Machine attempts to read a class 
 * file and determines that the major and minor version numbers
 * in the file are not supported.
 *
 * @since   1.2
 */
public class UnsupportedClassVersionError extends ClassFormatError {
    
    /**
     * Constructs a <code>UnsupportedClassVersionError</code> 
     * with no detail message. 
     */
    public UnsupportedClassVersionError() {}
    
    /**
     * Constructs a <code>UnsupportedClassVersionError</code> with
     * the specified detail message. 
     *
     * @param   s   the detail message.
     */
    public UnsupportedClassVersionError(String s) {}
}
