/*
 * @(#)IllegalThreadStateException.java	1.26 06/10/10
 *
 * Copyright (c) 1990, 2011, Oracle and/or its affiliates. All rights reserved.  
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */

package java.lang;

/**
 * Thrown to indicate that a thread is not in an appropriate state 
 * for the requested operation. See, for example, the 
 * <code>suspend</code> and <code>resume</code> methods in class 
 * <code>Thread</code>. 
 *
 * @author  unascribed
 * @version 1.19, 05/03/00
 * @since   JDK1.0
 */
public class IllegalThreadStateException extends IllegalArgumentException {
    
    /**
     * Constructs an <code>IllegalThreadStateException</code> with no 
     * detail message. 
     */
    public IllegalThreadStateException() {}
    
    /**
     * Constructs an <code>IllegalThreadStateException</code> with the 
     * specified detail message. 
     *
     * @param   s   the detail message.
     */
    public IllegalThreadStateException(String s) {}
}
