/*
 * @(#)ObjectStreamField.java	1.35 02/01/03
 *
 * Copyright (c) 1990, 2011, Oracle and/or its affiliates. All rights reserved.  
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */

package java.io;

import java.lang.reflect.Field;

/**
 * A description of a Serializable field from a Serializable class.
 * An array of ObjectStreamFields is used to declare the Serializable
 * fields of a class.
 *
 * @author	Mike Warres
 * @author	Roger Riggs
 * @version 1.38, 01/07/25
 * @see ObjectStreamClass
 * @since 1.2
 */
public class ObjectStreamField implements Comparable {
    
    
    
    
    
    
    
    
    /**
     * Create a Serializable field with the specified type.
     * This field should be documented with a <code>serialField</code>
     * tag. 
     *
     * @param n the name of the serializable field
     * @param clazz the <code>Class</code> object of the serializable field
     */
    public ObjectStreamField(String name, Class type) {}
    
    /**
     * Creates an ObjectStreamField representing a serializable field with the
     * given name and type.  If unshared is false, values of the represented
     * field are serialized and deserialized in the default manner--if the
     * field is non-primitive, object values are serialized and deserialized as
     * if they had been written and read by calls to writeObject and
     * readObject.  If unshared is true, values of the represented field are
     * serialized and deserialized as if they had been written and read by
     * calls to writeUnshared and readUnshared.
     *
     * @param   name field name
     * @param   type field type
     * @param   unshared if false, write/read field values in the same manner
     *          as writeObject/readObject; if true, write/read in the same
     *          manner as writeUnshared/readUnshared
     */
    public ObjectStreamField(String name, Class type, boolean unshared) {}
    
    /**
     * Creates an ObjectStreamField representing a field with the given name,
     * signature and unshared setting.
     */
    ObjectStreamField(String name, String signature, boolean unshared) {}
    
    /**
     * Creates an ObjectStreamField representing the given field with the
     * specified unshared setting.  For compatibility with the behavior of
     * earlier serialization implementations, a "showType" parameter is
     * necessary to govern whether or not a getType() call on this
     * ObjectStreamField (if non-primitive) will return Object.class (as
     * opposed to a more specific reference type).
     */
    ObjectStreamField(Field field, boolean unshared, boolean showType) {}
    
    /**
     * Get the name of this field.
     *
     * @return a <code>String</code> representing the name of the serializable
     * field 
     */
    public String getName() {
        return null;
    }
    
    /**
     * Get the type of the field.
     *
     * @return	the <code>Class</code> object of the serializable field 
     */
    public Class getType() {
        return null;
    }
    
    /**
     *
     * Returns character encoding of field type.  The encoding is as follows:
     * <blockquote><pre>
     * B            byte
     * C            char
     * D            double
     * F            float
     * I            int
     * J            long
     * L            class or interface
     * S            short
     * Z            boolean
     * [            array
     * </pre></blockquote>
     *
     * @return	the typecode of the serializable field
     */
    public char getTypeCode() {
        return '0';
    }
    
    /**
     * Return the JVM type signature.
     *
     * @return	null if this field has a primitive type.
     */
    public String getTypeString() {
        return null;
    }
    
    /**
     * Offset of field within instance data.
     *
     * @return	the offset of this field
     * @see #setOffset
     */
    public int getOffset() {
        return 0;
    }
    
    /**
     *
     * Offset within instance data.
     *
     * @param	offset the offset of the field
     * @see #getOffset
     */
    protected void setOffset(int offset) {
        return ;
    }
    
    /**
     * Return true if this field has a primitive type.
     *
     * @return	true if and only if this field corresponds to a primitive type
     */
    public boolean isPrimitive() {
        return false;
    }
    
    
    /**
     * Compare this field with another <code>ObjectStreamField</code>.
     * Return -1 if this is smaller, 0 if equal, 1 if greater.
     * Types that are primitives are "smaller" than object types.
     * If equal, the field names are compared.
     */
    public int compareTo(Object obj) {
        return 0;
    }
    
    /**
     * Return a string that describes this field.
     */
    public String toString() {
        return null;
    }
    
    
}
