/*
 * @(#)ObjectStreamConstants.java	1.36 06/10/10
 *
 * Copyright (c) 1990, 2011, Oracle and/or its affiliates. All rights reserved.  
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */

package java.io;

/**
 * Constants written into the Object Serialization Stream. 
 *
 * @author  unascribed
 * @version 1.29, 02/02/00
 * @since JDK 1.1
 */
public interface ObjectStreamConstants {
    
    /**
     * Magic number that is written to the stream header.
     */
    static final short STREAM_MAGIC = (short)44269;
    
    /**
     * Version number that is written to the stream header.
     */
    static final short STREAM_VERSION = 5;
    
    /**
     *
     * First tag value.
     */
    static final byte TC_BASE = 112;
    
    /**
     * Null object reference.
     */
    static final byte TC_NULL = (byte)112;
    
    /**
     * Reference to an object already written into the stream.
     */
    static final byte TC_REFERENCE = (byte)113;
    
    /**
     * new Class Descriptor.
     */
    static final byte TC_CLASSDESC = (byte)114;
    
    /**
     * new Object.
     */
    static final byte TC_OBJECT = (byte)115;
    
    /**
     *
     * new String.
     */
    static final byte TC_STRING = (byte)116;
    
    /**
     * new Array.
     */
    static final byte TC_ARRAY = (byte)117;
    
    /**
     * Reference to Class.
     */
    static final byte TC_CLASS = (byte)118;
    
    /**
     * Block of optional data. Byte following tag indicates number
     * of bytes in this block data.
     */
    static final byte TC_BLOCKDATA = (byte)119;
    
    /**
     *
     * End of optional block data blocks for an object.
     */
    static final byte TC_ENDBLOCKDATA = (byte)120;
    
    /**
     * Reset stream context. All handles written into stream are reset.
     */
    static final byte TC_RESET = (byte)121;
    
    /**
     * long Block data. The long following the tag indicates the
     * number of bytes in this block data.
     */
    static final byte TC_BLOCKDATALONG = (byte)122;
    
    /**
     * Exception during write. 
     */
    static final byte TC_EXCEPTION = (byte)123;
    
    /**
     * Long string.
     */
    static final byte TC_LONGSTRING = (byte)124;
    
    /**
     * new Proxy Class Descriptor.
     */
    static final byte TC_PROXYCLASSDESC = (byte)125;
    
    /**
     *
     * Last tag value.
     */
    static final byte TC_MAX = (byte)125;
    
    /**
     * First wire handle to be assigned. 
     */
    static final int baseWireHandle = 8257536;
    
    /**
     *
     * Bit mask for ObjectStreamClass flag. Indicates a Serializable class 
     * defines its own writeObject method.
     */
    static final byte SC_WRITE_METHOD = 1;
    
    /**
     * Bit mask for ObejctStreamClass flag. Indicates Externalizable data 
     * written in Block Data mode.
     * Added for PROTOCOL_VERSION_2.
     *
     * @see #PROTOCOL_VERSION_2
     * @since 1.2
     */
    static final byte SC_BLOCK_DATA = 8;
    
    /**
     * Bit mask for ObjectStreamClass flag. Indicates class is Serializable.
     */
    static final byte SC_SERIALIZABLE = 2;
    
    /**
     * Bit mask for ObjectStreamClass flag. Indicates class is Externalizable.
     */
    static final byte SC_EXTERNALIZABLE = 4;
    
    /**
     * Enable substitution of one object for another during 
     * serialization/deserialization.
     *
     * @see java.io.ObjectOutputStream#enableReplaceObject(boolean)
     * @see java.io.ObjectInputStream#enableResolveObject(boolean)
     * @since 1.2
     */
    static final SerializablePermission SUBSTITUTION_PERMISSION = new SerializablePermission("enableSubstitution");
    
    /**
     * Enable overriding of readObject and writeObject.
     *
     * @see java.io.ObjectOutputStream#writeObjectOverride(Object)
     * @see java.io.ObjectInputStream#readObjectOverride()
     * @since 1.2
     */
    static final SerializablePermission SUBCLASS_IMPLEMENTATION_PERMISSION = new SerializablePermission("enableSubclassImplementation");
    
    /**
     * A Stream Protocol Version. <p>
     * 
     * All externalizable data is written in JDK 1.1 external data 
     * format after calling this method. This version is needed to write 
     * streams containing Externalizable data that can be read by 
     * pre-JDK 1.1.6 JVMs.
     *
     * @see java.io.ObjectOutputStream#useProtocolVersion(int)
     * @since 1.2
     */
    public static final int PROTOCOL_VERSION_1 = 1;
    
    /**
     * A Stream Protocol Version. <p>
     * 
     * This protocol is written by JVM 1.2.
     *
     * Externalizable data is written in block data mode and is 
     * terminated with TC_ENDBLOCKDATA. Externalizable classdescriptor
     * flags has SC_BLOCK_DATA enabled. JVM 1.1.6 and greater can 
     * read this format change.
     *
     * Enables writing a nonSerializable class descriptor into the
     * stream. The serialVersionUID of a nonSerializable class is 
     * set to 0L. 
     *
     * @see java.io.ObjectOutputStream#useProtocolVersion(int)
     * @see #SC_BLOCK_DATA
     * @since 1.2
     */
    public static final int PROTOCOL_VERSION_2 = 2;
}
