/*
 * Copyright 2003 Sun Microsystems, Inc. All rights reserved.
 * SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * @(#)Timestamp.java	1.8 03/10/21
 */

package java.sql;

import java.text.*;
import java.util.Calendar;
import java.util.GregorianCalendar;

/**
 * <P>A thin wrapper around <code>java.util.Date</code> that allows
 * the JDBC API to identify this as an SQL <code>TIMESTAMP</code> value.
 * It adds the ability
 * to hold the SQL <code>TIMESTAMP</code> nanos value and provides formatting and
 * parsing operations to support the JDBC escape syntax for timestamp values.
 *
 * <P><B>Note:</B> This type is a composite of a <code>java.util.Date</code> and a
 * separate nanoseconds value. Only integral seconds are stored in the
 * <code>java.util.Date</code> component. The fractional seconds - the nanos - are
 * separate. The <code>getTime</code> method will return only integral seconds. If
 * a time value that includes the fractional seconds is desired, you
 * must convert nanos to milliseconds (nanos/1000000) and add this to
 * the <code>getTime</code> value.  The
 * <code>Timestamp.equals(Object)</code> method never returns 
 * <code>true</code> when passed a value of type <code>java.util.Date</code>
 * because the nanos component of a date is unknown.
 * As a result, the <code>Timestamp.equals(Object)</code>
 * method is not symmetric with respect to the
 * <code>java.util.Date.equals(Object)</code>
 * method.  Also, the <code>hashcode</code> method uses the underlying 
 * <code>java.util.Data</code> 
 * implementation and therefore does not include nanos in its computation.  
 * 
 * Due to the differences between the <code>Timestamp</code> class
 * and the <code>java.util.Date</code>
 * class mentioned above, it is recommended that code not view
 * <code>Timestamp</code> values generically as an instance of
 * <code>java.util.Date</code>.  The
 * inheritance relationship between <code>Timestamp</code>
 * and <code>java.util.Date</code> really 
 * denotes implementation inheritance, and not type inheritance.  
 */
public class Timestamp extends java.util.Date {
    
    /**
     * Constructs a <code>Timestamp</code> object 
     * using a milliseconds time value. The
     * integral seconds are stored in the underlying date value; the
     * fractional seconds are stored in the <code>nanos</code> field of
     * the <code>Timestamp</code> object.
     *
     * @param time milliseconds since January 1, 1970, 00:00:00 GMT.
     *        A negative number is the number of milliseconds before
     *         January 1, 1970, 00:00:00 GMT.
     * @see java.util.Calendar for more information
     */
    public Timestamp(long time) {}
    
    /**
     * Sets this <code>Timestamp</code> object to represent a point in time that is 
     * <tt>time</tt> milliseconds after January 1, 1970 00:00:00 GMT. 
     *
     * @param time   the number of milliseconds.
     * @see #getTime
     * @see #Timestamp(long time)
     * @see java.util.Calendar for more information
     */
    public void setTime(long time) {
        return ;
    }
    
    /**
     * Returns the number of milliseconds since January 1, 1970, 00:00:00 GMT
     * represented by this <code>Timestamp</code> object.
     *
     * @return  the number of milliseconds since January 1, 1970, 00:00:00 GMT
     *          represented by this date.
     * @see #setTime
     */
    public long getTime() {
        return 0L;
    }
    
    
    /**
     * Converts a <code>String</code> object in JDBC timestamp escape format to a
     * <code>Timestamp</code> value.
     *
     * @param s timestamp in format <code>yyyy-mm-dd hh:mm:ss.fffffffff</code>
     * @return corresponding <code>Timestamp</code> value
     * @exception java.lang.IllegalArgumentException if the given argument
     * does not have the format <code>yyyy-mm-dd hh:mm:ss.fffffffff</code>
     */
    public static Timestamp valueOf(String s) {
        return null;
    }
    
    /**
     * Formats a timestamp in JDBC timestamp escape format.
     *
     * NOTE: To specify a timestamp format for the class 
     * <code>SimpleDateFormat</code>, use "yyyy.MM.dd" rather than 
     * "yyyy-mm-dd". In the context of <code>SimpleDateFormat</code>, "mm"
     * indicates minutes rather than the month. Note that 
     * <code>SimpleDateFormat<code> does not allw for the nanoseconds 
     * components of a <code>Timestamp</code> object.
     * For example:
     * <PRE>
     *
     *  Format Pattern				Result
     *  --------------                  	------
     * `    *  "yyyy.MM.dd G 'at' hh:mm:ss z"     -->	2002.07.10 AD at 15:08:56 PDT
     *
     * </PRE>
     * @return a <code>String</code> object in
     *           <code>yyyy-mm-dd hh:mm:ss.fffffffff</code> format
     * @overrides <code>toString</code> in class <code>java.util.Date</code>
     */
    public String toString() {
        return null;
    }
    
    /**
     * Gets this <code>Timestamp</code> object's <code>nanos</code> value.
     *
     * @return this <code>Timestamp</code> object's fractional seconds component
     * @see #setNanos
     */
    public int getNanos() {
        return 0;
    }
    
    /**
     * Sets this <code>Timestamp</code> object's <code>nanos</code> field
     * to the given value.
     *
     * @param n the new fractional seconds component
     * @exception java.lang.IllegalArgumentException if the given argument
     *            is greater than 999999999 or less than 0
     * @see #getNanos
     */
    public void setNanos(int n) {
        return ;
    }
    
    /**
     * Tests to see if this <code>Timestamp</code> object is
     * equal to the given <code>Timestamp</code> object.
     *
     * @param ts the <code>Timestamp</code> value to compare with
     * @return <code>true</code> if the given <code>Timestamp</code>
     *         object is equal to this <code>Timestamp</code> object;
     *         <code>false</code> otherwise
     */
    public boolean equals(Timestamp ts) {
        return false;
    }
    
    /**
     * Tests to see if this <code>Timestamp</code> object is
     * equal to the given object.
     *
     * This version of the method <code>equals</code> has been added
     * to fix the incorrect 
     * signature of <code>Timestamp.equals(Timestamp)</code> and to preserve backward 
     * compatibility with existing class files.
     *
     * Note: This method is not symmetric with respect to the 
     * <code>equals(Object)</code> method in the base class.
     *
     * @param ts the <code>Object</code> value to compare with
     * @return <code>true</code> if the given <code>Object</code>
     *         instance is equal to this <code>Timestamp</code> object;
     *         <code>false</code> otherwise
     */
    public boolean equals(java.lang.Object ts) {
        return false;
    }
    
    /**
     * Indicates whether this <code>Timestamp</code> object is
     * earlier than the given <code>Timestamp</code> object.
     *
     * @param ts the <code>Timestamp</code> value to compare with
     * @return <code>true</code> if this <code>Timestamp</code> object is earlier;
     *        <code>false</code> otherwise
     */
    public boolean before(Timestamp ts) {
        return false;
    }
    
    /**
     * Indicates whether this <code>Timestamp</code> object is
     * later than the given <code>Timestamp</code> object.
     *
     * @param ts the <code>Timestamp</code> value to compare with
     * @return <code>true</code> if this <code>Timestamp</code> object is later;
     *        <code>false</code> otherwise
     */
    public boolean after(Timestamp ts) {
        return false;
    }
    
    /**
     * Compares two Timestamps for ordering.
     *
     * @param   ts   the <code>Timestamp</code> to be compared.
     * @return  the value <code>0</code> if the argument Timestamp is equal to
     *          this Timestamp; a value less than <code>0</code> if this 
     *          Timestamp is before the Date argument; and a value greater than
     *      <code>0</code> if this Timestamp is after the Timestamp argument.
     * @since   1.2
     */
    public int compareTo(Timestamp ts) {
        return 0;
    }
    
    /**
     * Compares this Timestamp to another Object. If the Object is 
     * a Timestamp, this function behaves like compareTo(Timestamp). 
     * Otherwise, it throws aClassCastException (as Timestamps are 
     * comparable only to other Timestamps)
     *
     * @param o the <code>object</code> to be compared
     *
     * @return the value <code>0</code> if the argument is a Timestamp 
     * equal to this Timestamp; a value less than <code>0</code> if the 
     * argument is a Timestamp after this Timestamp; and a value 
     * greater than <code>0</code> if the argument is a Timestamp 
     * before this Timestamp.
     *
     * @exception ClassCastException if the argument is not a
     *        <code>Timestamp</code>.
     */
    public int compareTo(Object o) {
        return 0;
    }
    
}
