/*
 * @(#)UnsatisfiedLinkError.java	1.25 06/10/10
 *
 * Copyright (c) 1990, 2011, Oracle and/or its affiliates. All rights reserved.  
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */

package java.lang;

/**
 * Thrown if the Java Virtual Machine cannot find an appropriate 
 * native-language definition of a method declared <code>native</code>. 
 *
 * @author unascribed
 * @version 1.18, 02/02/00
 * @see     java.lang.Runtime
 * @since   JDK1.0
 */
public class UnsatisfiedLinkError extends LinkageError {
    
    /**
     * Constructs an <code>UnsatisfiedLinkError</code> with no detail message.
     */
    public UnsatisfiedLinkError() {}
    
    /**
     * Constructs an <code>UnsatisfiedLinkError</code> with the 
     * specified detail message. 
     *
     * @param   s   the detail message.
     */
    public UnsatisfiedLinkError(String s) {}
}
