/*
 * @(#)ThreadLocal.java	1.23 06/10/10
 *
 * Copyright (c) 1990, 2011, Oracle and/or its affiliates. All rights reserved.  
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */

package java.lang;

import java.lang.ref.*;

/**
 * This class provides thread-local variables.  These variables differ from
 * their normal counterparts in that each thread that accesses one (via its
 * <tt>get</tt> or <tt>set</tt> method) has its own, independently initialized
 * copy of the variable.  <tt>ThreadLocal</tt> instances are typically private
 * static fields in classes that wish to associate state with a thread (e.g.,
 * a user ID or Transaction ID).
 *
 * <p>For example, in the class below, the private static <tt>ThreadLocal</tt>
 * instance (<tt>serialNum</tt>) maintains a "serial number" for each thread
 * that invokes the class's static <tt>SerialNum.get()</tt> method, which
 * returns the current thread's serial number.  (A thread's serial number is
 * assigned the first time it invokes <tt>SerialNum.get()</tt>, and remains
 * unchanged on subsequent calls.)
 * <pre>
 * public class SerialNum {
 *     // The next serial number to be assigned
 *     private static int nextSerialNum = 0;
 * 
 *     private static ThreadLocal serialNum = new ThreadLocal() {
 *         protected synchronized Object initialValue() {
 *             return new Integer(nextSerialNum++);
 *         }
 *     };
 * 
 *     public static int get() {
 *         return ((Integer) (serialNum.get())).intValue();
 *     }
 * }
 * </pre>
 * 
 * <p>Each thread holds an implicit reference to its copy of a thread-local
 * variable as long as the thread is alive and the <tt>ThreadLocal</tt>
 * instance is accessible; after a thread goes away, all of its copies of
 * thread-local instances are subject to garbage collection (unless other
 * references to these copies exist). 
 *
 * @author  Josh Bloch and Doug Lea
 * @version 1.23, 10/10/06
 * @since   1.2
 */
public class ThreadLocal {
    
    
    
    
    
    /**
     * Returns the current thread's initial value for this thread-local
     * variable.  This method will be invoked at most once per accessing
     * thread for each thread-local, the first time the thread accesses the
     * variable with the {@link #get()} method.  The <tt>initialValue</tt>
     * method will not be invoked in a thread if the thread invokes the {@link
     * #set(Object)} method prior to the <tt>get</tt> method.
     *
     * <p>This implementation simply returns <tt>null</tt>; if the programmer
     * desires thread-local variables to be initialized to some value other
     * than <tt>null</tt>, <tt>ThreadLocal</tt> must be subclassed, and this
     * method overridden.  Typically, an anonymous inner class will be used.
     * Typical implementations of <tt>initialValue</tt> will invoke an
     * appropriate constructor and return the newly constructed object.
     *
     * @return the initial value for this thread-local
     */
    protected Object initialValue() {
        return null;
    }
    
    /**
     * Returns the value in the current thread's copy of this thread-local
     * variable.  Creates and initializes the copy if this is the first time
     * the thread has called this method.
     *
     * @return the current thread's value of this thread-local
     */
    public Object get() {
        return null;
    }
    
    /**
     * Sets the current thread's copy of this thread-local variable
     * to the specified value.  Many applications will have no need for
     * this functionality, relying solely on the {@link #initialValue()}
     * method to set the values of thread-locals.
     *
     * @param value the value to be stored in the current threads' copy of
     *	      this thread-local.
     */
    public void set(Object value) {
        return ;
    }
    
    
    
    
    
}
