/*
 * @(#)InstantiationException.java	1.21 06/10/10
 *
 * Copyright (c) 1990, 2011, Oracle and/or its affiliates. All rights reserved.  
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */

package java.lang;

/**
 * Thrown when an application tries to create an instance of a class 
 * using the <code>newInstance</code> method in class 
 * <code>Class</code>, but the specified class object cannot be 
 * instantiated because it is an interface or is an abstract class. 
 *
 * @author  unascribed
 * @version 1.14, 02/02/00
 * @see     java.lang.Class#newInstance()
 * @since   JDK1.0
 */
public class InstantiationException extends Exception {
    
    /**
     * Constructs an <code>InstantiationException</code> with no detail message.
     */
    public InstantiationException() {}
    
    /**
     * Constructs an <code>InstantiationException</code> with the 
     * specified detail message. 
     *
     * @param   s   the detail message.
     */
    public InstantiationException(String s) {}
}
