/*
 * @(#)StringWriter.java	1.25 06/10/10
 *
 * Copyright (c) 1990, 2011, Oracle and/or its affiliates. All rights reserved.  
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */

package java.io;

/**
 * A character stream that collects its output in a string buffer, which can
 * then be used to construct a string.
 * <p>
 * Closing a <tt>StringWriter</tt> has no effect. The methods in this class
 * can be called after the stream has been closed without generating an
 * <tt>IOException</tt>.
 *
 * @version 	1.18, 00/02/02
 * @author	Mark Reinhold
 * @since	JDK1.1
 */
public class StringWriter extends Writer {
    
    
    /**
     * Create a new string writer, using the default initial string-buffer
     * size.
     */
    public StringWriter() {}
    
    /**
     * Create a new string writer, using the specified initial string-buffer
     * size.
     *
     * @param initialSize  an int specifying the initial size of the buffer.
     */
    public StringWriter(int initialSize) {}
    
    /**
     * Write a single character.
     */
    public void write(int c) {
        return ;
    }
    
    /**
     * Write a portion of an array of characters.
     *
     * @param  cbuf  Array of characters
     * @param  off   Offset from which to start writing characters
     * @param  len   Number of characters to write
     */
    public void write(char[] cbuf, int off, int len) {
        return ;
    }
    
    /**
     * Write a string.
     */
    public void write(String str) {
        return ;
    }
    
    /**
     * Write a portion of a string.
     *
     * @param  str  String to be written
     * @param  off  Offset from which to start writing characters
     * @param  len  Number of characters to write
     */
    public void write(String str, int off, int len) {
        return ;
    }
    
    /**
     * Return the buffer's current value as a string.
     */
    public String toString() {
        return null;
    }
    
    /**
     * Return the string buffer itself.
     *
     * @return StringBuffer holding the current buffer value.
     */
    public StringBuffer getBuffer() {
        return null;
    }
    
    /**
     * Flush the stream.
     */
    public void flush() {
        return ;
    }
    
    /**
     * Closing a <tt>StringWriter</tt> has no effect. The methods in this
     * class can be called after the stream has been closed without generating
     * an <tt>IOException</tt>.
     */
    public void close() throws IOException {
        return ;
    }
}
