/*
 * @(#)CharArrayWriter.java	1.22 06/10/10
 *
 * Copyright (c) 1990, 2011, Oracle and/or its affiliates. All rights reserved.  
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */

package java.io;

/**
 * This class implements a character buffer that can be used as an Writer.
 * The buffer automatically grows when data is written to the stream.  The data
 * can be retrieved using toCharArray() and toString().
 *
 * @author	Herb Jellinek
 * @version 	1.15, 02/02/00
 * @since       JDK1.1
 */
public class CharArrayWriter extends Writer {
    
    /**
     * The buffer where data is stored.
     */
    protected char[] buf;
    
    /**
     * The number of chars in the buffer.
     */
    protected int count;
    
    /**
     * Creates a new CharArrayWriter.
     */
    public CharArrayWriter() {}
    
    /**
     * Creates a new CharArrayWriter with the specified initial size.
     *
     * @param initialSize  an int specifying the initial buffer size.
     * @exception IllegalArgumentException if initialSize is negative
     */
    public CharArrayWriter(int initialSize) {}
    
    /**
     * Writes a character to the buffer.
     */
    public void write(int c) {
        return ;
    }
    
    /**
     * Writes characters to the buffer.
     * @param c	the data to be written
     * @param off	the start offset in the data
     * @param len	the number of chars that are written
     */
    public void write(char[] c, int off, int len) {
        return ;
    }
    
    /**
     * Write a portion of a string to the buffer.
     * @param  str  String to be written from
     * @param  off  Offset from which to start reading characters
     * @param  len  Number of characters to be written
     */
    public void write(String str, int off, int len) {
        return ;
    }
    
    /**
     * Writes the contents of the buffer to another character stream.
     *
     * @param out	the output stream to write to
     * @throws IOException If an I/O error occurs.
     */
    public void writeTo(Writer out) throws IOException {
        return ;
    }
    
    /**
     * Resets the buffer so that you can use it again without
     * throwing away the already allocated buffer.
     */
    public void reset() {
        return ;
    }
    
    /**
     * Returns a copy of the input data.
     *
     * @return an array of chars copied from the input data.
     */
    public char[] toCharArray() {
        return null;
    }
    
    /**
     * Returns the current size of the buffer.
     *
     * @return an int representing the current size of the buffer.
     */
    public int size() {
        return 0;
    }
    
    /**
     * Converts input data to a string.
     * @return the string.
     */
    public String toString() {
        return null;
    }
    
    /**
     * Flush the stream.
     */
    public void flush() {
        return ;
    }
    
    /**
     * Close the stream.  This method does not release the buffer, since its
     * contents might still be required.
     */
    public void close() {
        return ;
    }
}
