/*
 * @(#)EventListenerProxy.java	1.7 06/10/10
 *
 * Copyright (c) 1990, 2011, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package java.util;

/**
 * An abstract wrapper class for an EventListener class which associates a set
 * of additional parameters with the listener. Subclasses must provide the
 * storage and accessor methods for the additional arguments or parameters.
 * 
 * Subclasses of EventListerProxy may be returned by getListeners() methods
 * as a way of associating named properties with their listeners.
 *
 * If the calling method is interested in retrieving the named property then it
 * would have to test the element to see if it is a proxy class.
 * 
 * @since 1.4
 */
public abstract class EventListenerProxy implements EventListener {
    
    
    /**
     * @param listener The listener object.
     */
    public EventListenerProxy(EventListener listener) {}
    
    /**
     * @return The listener associated with this proxy.
     */
    public EventListener getListener() {
        return null;
    }
}
