/*
 * Copyright 2003 Sun Microsystems, Inc. All rights reserved.
 * SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * @(#)Date.java	1.10 03/10/21
 */

package java.sql;

import java.text.*;
import java.util.Calendar;
import java.util.GregorianCalendar;

/**
 * <P>A thin wrapper around a millisecond value that allows
 * JDBC to identify this as an SQL <code>DATE</code> value.  A 
 * milliseconds value represents the number of milliseconds that 
 * have passed since January 1, 1970 00:00:00.000 GMT.
 * <p>
 * To conform with the definition of SQL <code>DATE</code>, the 
 * millisecond values wrapped by a <code>java.sql.Date</code> instance 
 * must be 'normalized' by setting the 
 * hours, minutes, seconds, and milliseconds to zero in the particular
 * time zone with which the instance is associated.
 */
public class Date extends java.util.Date {
    
    /**
     * Constructs a <code>Date</code> object using the given milliseconds 
     * time value.  If the given milliseconds value contains time 
     * information, the driver will set the time components to the
     * time in the default time zone (the time zone of the Java virtual
     * machine running the application) that corresponds to zero GMT.
     *
     * @param date milliseconds since January 1, 1970, 00:00:00 GMT not
     *        to exceed the milliseconds representation for the year 8099.
     *        A negative number indicates the number of milliseconds
     *        before January 1, 1970, 00:00:00 GMT.
     */
    public Date(long date) {}
    
    /**
     * Sets an existing <code>Date</code> object 
     * using the given milliseconds time value. 
     * If the given milliseconds value contains time information, 
     * the driver will set the time components to the
     * time in the default time zone (the time zone of the Java virtual
     * machine running the application) that corresponds to zero GMT.
     *
     * @param date milliseconds since January 1, 1970, 00:00:00 GMT not
     *        to exceed the milliseconds representation for the year 8099.
     *        A negative number indicates the number of milliseconds
     *        before January 1, 1970, 00:00:00 GMT.
     */
    public void setTime(long date) {
        return ;
    }
    
    /**
     * Converts a string in JDBC date escape format to
     * a <code>Date</code> value.
     *
     * @param s date in format "yyyy-mm-dd"
     * @return a <code>java.sql.Date</code> object representing the 
     *         given date
     */
    public static Date valueOf(String s) {
        return null;
    }
    
    /**
     * Formats a date in the date escape format yyyy-mm-dd.  
     * <P>
     * NOTE:  To specify a date format for the class
     * <code>SimpleDateFormat</code>, use "yyyy.MM.dd" rather than
     * "yyyy-mm-dd".  In the context of <code>SimpleDateFormat</code>,
     * "mm" indicates minutes rather than the month.  
     * For example:
     * <PRE>
     *
     *  Format Pattern                         Result
     *  --------------                         -------
     *	"yyyy.MM.dd G 'at' hh:mm:ss z"    ->>  1996.07.10 AD at 15:08:56 PDT
     * </PRE>
     * @return a String in yyyy-mm-dd format
     */
    public String toString() {
        return null;
    }
    
}
