/*
 * @(#)CertificateException.java	1.34 06/10/10
 *
 * Copyright (c) 1990, 2011, Oracle and/or its affiliates. All rights reserved.  
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */

package java.security.cert;

import java.security.GeneralSecurityException;

/**
 * This exception indicates one of a variety of certificate problems.
 *
 * @author Hemma Prafullchandra
 * @version 1.27
 * @see Certificate
 */
public class CertificateException extends GeneralSecurityException {
    
    /**
     * Constructs a certificate exception with no detail message. A detail
     * message is a String that describes this particular exception. 
     */
    public CertificateException() {}
    
    /**
     * Constructs a certificate exception with the given detail
     * message. A detail message is a String that describes this
     * particular exception.
     *
     * @param msg the detail message.  
     */
    public CertificateException(String msg) {}
}
