/*
 * @(#)NumberFormatException.java	1.23 06/10/10
 *
 * Copyright (c) 1990, 2011, Oracle and/or its affiliates. All rights reserved.  
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */

package java.lang;

/**
 * Thrown to indicate that the application has attempted to convert 
 * a string to one of the numeric types, but that the string does not 
 * have the appropriate format. 
 *
 * @author  unascribed
 * @version 1.16, 02/02/00
 * @see     java.lang.Integer#toString()
 * @since   JDK1.0
 */
public class NumberFormatException extends IllegalArgumentException {
    
    
    /**
     * Constructs a <code>NumberFormatException</code> with no detail message.
     */
    public NumberFormatException() {}
    
    /**
     * Constructs a <code>NumberFormatException</code> with the 
     * specified detail message. 
     *
     * @param   s   the detail message.
     */
    public NumberFormatException(String s) {}
    
}
