/*
 * @(#)IncompatibleClassChangeError.java	1.22 06/10/10
 *
 * Copyright (c) 1990, 2011, Oracle and/or its affiliates. All rights reserved.  
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */

package java.lang;

/**
 * Thrown when an incompatible class change has occurred to some class 
 * definition. The definition of some class, on which the currently 
 * executing method depends, has since changed. 
 *
 * @author  unascribed
 * @version 1.15, 02/02/00
 * @since   JDK1.0
 */
public class IncompatibleClassChangeError extends LinkageError {
    
    /**
     * Constructs an <code>IncompatibleClassChangeError</code> with no 
     * detail message. 
     */
    public IncompatibleClassChangeError() {}
    
    /**
     * Constructs an <code>IncompatibleClassChangeError</code> with the 
     * specified detail message. 
     *
     * @param   s   the detail message.
     */
    public IncompatibleClassChangeError(String s) {}
}
