package mobile;

import oracle.adfmf.java.beans.PropertyChangeListener;
import oracle.adfmf.java.beans.PropertyChangeSupport;

public class WeatherDescription {
    private String description = "";
    private String pictureURL = "";
    private Short weatherID;
    private transient PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public WeatherDescription() {
        super();
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        propertyChangeSupport.removePropertyChangeListener(l);
    }

    public void setDescription(String Description) {
        String oldDescription = this.description;
        this.description = Description;
        propertyChangeSupport.firePropertyChange("description", oldDescription, Description);
    }

    public String getDescription() {
        return description;
    }

    public void setPictureURL(String PictureURL) {
        String oldPictureURL = this.pictureURL;
        this.pictureURL = PictureURL;
        propertyChangeSupport.firePropertyChange("pictureURL", oldPictureURL, PictureURL);
    }

    public String getPictureURL() {
        return pictureURL;
    }

    public void setWeatherID(Short WeatherID) {
        Short oldWeatherID = this.weatherID;
        this.weatherID = WeatherID;
        propertyChangeSupport.firePropertyChange("weatherID", oldWeatherID, WeatherID);
    }

    public Short getWeatherID() {
        return weatherID;
    }
}
