package mobile;

import com.sun.util.logging.Level;

import java.util.ArrayList;
import java.util.List;

import oracle.adfmf.framework.api.AdfmfJavaUtilities;
import oracle.adfmf.framework.api.GenericTypeBeanSerializationHelper;
import oracle.adfmf.framework.exception.AdfException;
import oracle.adfmf.framework.exception.AdfInvocationException;
import oracle.adfmf.java.beans.ProviderChangeListener;
import oracle.adfmf.java.beans.ProviderChangeSupport;
import oracle.adfmf.util.GenericType;
import oracle.adfmf.util.Utility;
import oracle.adfmf.util.logging.Trace;

public class WeatherInformation {
    private static List s_weatherdescs = null;
    private boolean haveWeatherInfo = false;
    private transient ProviderChangeSupport providerChangeSupport = new ProviderChangeSupport(this);

    public WeatherInformation() {
        super();
        if (s_weatherdescs == null) {
            s_weatherdescs = new ArrayList();
            
            WeatherDescription wd = new WeatherDescription();
            wd.setDescription("............No Data");
            AddWeatherDescription(wd);
        }

    }

    public void addProviderChangeListener(ProviderChangeListener l) {
        providerChangeSupport.addProviderChangeListener(l);
    }

    public void removeProviderChangeListener(ProviderChangeListener l) {
        providerChangeSupport.removeProviderChangeListener(l);
    }


    public void AddWeatherDescription(WeatherDescription w) {
        s_weatherdescs.add(w);
    }

    public WeatherDescription[] getWeatherDescriptions() {
        WeatherDescription wd[] = null;

        wd = (WeatherDescription[])s_weatherdescs.toArray(new WeatherDescription[s_weatherdescs.size()]);

        return wd;
    }

    /**
     * This method is called from the getImage method of Forecast 
     * We use helper method to retrieve the image URL from the weatherInfo for the particular Forecast
     **/ 
    public String getWeatherImage(Short weatherID) {
        String ret = "";
        int count = s_weatherdescs.size();

        for (int i = 0; i < count; i++) {
            WeatherDescription wd = (WeatherDescription)s_weatherdescs.get(i);

            Short id = wd.getWeatherID();

            if (id.compareTo(weatherID) == 0) {
                ret = wd.getPictureURL();
                break;
            }
        }
        return ret;
    }

    /**
     * This method is called from the WeatherBean 
     * We use this method to invoke the Web Service from the DC and parse the results into a bean 
     **/ 
    public boolean retreiveWeatherInfo() {
        Trace.log(Utility.ApplicationLogger, Level.INFO, WeatherBean.class, "retreiveWeatherInfo",
                  ">>>>>> Inside retreiveWeatherInfo");

        // We only load the weather info once
        if (!haveWeatherInfo) {

            List nullParams = new ArrayList();

            try {
                Trace.log(Utility.ApplicationLogger, Level.INFO, WeatherBean.class, "retreiveWeatherInfo",
                          ">>>>>> Before invokeDataControlMethod");

                // This calls the DC method and gives us the Return
                GenericType result =
                    (GenericType)AdfmfJavaUtilities.invokeDataControlMethod("WeatherDC", null, "GetWeatherInformation",
                                                                            nullParams, nullParams, nullParams);

                // The Return wraps the GetWeatherInformationResult, so get that out of the Result
                GenericType infoResult = (GenericType)result.getAttribute(0);
                
                // Clear the weatherDescriptions collection
                s_weatherdescs.clear();

                // GetWeatherInformationResult has a subcollection of WeatherDescription objects, get all those in a loop
                for (int i = 0; i < infoResult.getAttributeCount(); i++) {
                    // Get each individual WeatherDescription object
                    GenericType wdgt = (GenericType)infoResult.getAttribute(i);

                    // Now make a real WeatherDescription java object out of this GenericType
                    WeatherDescription wd =
                        (WeatherDescription)GenericTypeBeanSerializationHelper.fromGenericType(WeatherDescription.class,
                                                                                               wdgt);

                    // Now add this to our holder of all WeatherDescriptions
                    AddWeatherDescription(wd);
                }
                providerChangeSupport.fireProviderRefresh("weatherDescriptions");

                haveWeatherInfo = true;

                Trace.log(Utility.ApplicationLogger, Level.INFO, WeatherBean.class, "retreiveWeatherInfo",
                          ">>>>>> End invokeDataControlMethod");
            } catch (AdfInvocationException e) {
                Trace.log(Utility.ApplicationLogger, Level.SEVERE, WeatherBean.class, "retreiveWeatherInfo",
                          ">>>>>>" + e.getMessage());

                AdfException ex =
                    new AdfException("Error Invoking Web Service.  Please try later", AdfException.WARNING);
                throw ex;
            } catch (Exception e2) {
                Trace.log(Utility.ApplicationLogger, Level.SEVERE, WeatherBean.class, "retreiveWeatherInfo",
                          ">>>>>> Exception=" + e2.getMessage());
                AdfException ex =
                    new AdfException("Error Invoking Web Service.  Please try later", AdfException.WARNING);
                throw ex;
            }
        }
        return haveWeatherInfo;
    }

}
