package mobile;

import java.util.ArrayList;
import java.util.List;

import oracle.adfmf.java.beans.PropertyChangeListener;
import oracle.adfmf.java.beans.PropertyChangeSupport;
import oracle.adfmf.java.beans.ProviderChangeListener;
import oracle.adfmf.java.beans.ProviderChangeSupport;

public class CityForecast {
    private Boolean success = Boolean.FALSE;
    private String city = "";
    private String responseText = "";
    private String state = "";
    private String weatherStationCity = "";
    private static List s_forecast = null;
    private transient PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private transient ProviderChangeSupport providerChangeSupport = new ProviderChangeSupport(this);

    public CityForecast() {
        super();
        if (s_forecast == null) {
            s_forecast = new ArrayList();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        propertyChangeSupport.removePropertyChangeListener(l);
    }

    public void addProviderChangeListener(ProviderChangeListener l) {
        providerChangeSupport.addProviderChangeListener(l);
    }

    public void removeProviderChangeListener(ProviderChangeListener l) {
        providerChangeSupport.removeProviderChangeListener(l);
    }

    
    public void setSuccess(Boolean success) {
        Boolean oldSuccess = this.success;
        this.success = success;
        propertyChangeSupport.firePropertyChange("success", oldSuccess, success);
    }

    public Boolean isSuccess() {
        return success;
    }

    public void setCity(String city) {
        String oldCity = this.city;
        this.city = city;
        propertyChangeSupport.firePropertyChange("city", oldCity, city);
    }

    public String getCity() {
        return city;
    }

    public void setResponseText(String responseText) {
        String oldResponseText = this.responseText;
        this.responseText = responseText;
        propertyChangeSupport.firePropertyChange("responseText", oldResponseText, responseText);
    }

    public String getResponseText() {
        return responseText;
    }

    public void setState(String state) {
        String oldState = this.state;
        this.state = state;
        propertyChangeSupport.firePropertyChange("state", oldState, state);
    }

    public String getState() {
        return state;
    }

    public void setWeatherStationCity(String weatherStationCity) {
        String oldWeatherStationCity = this.weatherStationCity;
        this.weatherStationCity = weatherStationCity;
        propertyChangeSupport.firePropertyChange("weatherStationCity", oldWeatherStationCity, weatherStationCity);
    }

    public String getWeatherStationCity() {
        return weatherStationCity;
    }
    
    public Forecast[] getForecast() {
        Forecast f[] = null;

        f = (Forecast[])s_forecast.toArray(new Forecast[s_forecast.size()]);

        return f;
    }
    
    public void clearForecast() {
        s_forecast.clear();
        providerChangeSupport.fireProviderRefresh("forecast");
    }
    
    public void addForecast(Forecast f) {
        s_forecast.add(f);
        providerChangeSupport.fireProviderCreate("forecast", f.getDate(), f);
    }
}
