package Portfolio;

import java.text.NumberFormat;

import oracle.adfmf.java.beans.PropertyChangeListener;
import oracle.adfmf.java.beans.PropertyChangeSupport;

public class Stock {

    private transient PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public Stock() {
    }

    private int id = 0;
    private String ticker = "";
    private String company = "";
    private Double price;
    private Double previous;
    private Long volume;

    public Stock(int id, String ticker, String company, Double price, Double previous, Long volume) {
        this.id = id;
        this.ticker = ticker;
        this.company = company;
        this.price = price;
        this.previous = previous;
        this.volume = volume;
    }
    
    public String getChange() {
        String c = "color:green";
        if( price.doubleValue() < previous.doubleValue() ) {
            c = "color:red";
        }
        return c;
    }


    public Double getPercent() {
        return new Double((price.doubleValue() - previous.doubleValue()) / previous.doubleValue() * 100);
    }

    public void setId(int id) {
        int oldId = this.id;
        this.id = id;
        propertyChangeSupport.firePropertyChange("id", oldId, id);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        propertyChangeSupport.removePropertyChangeListener(l);
    }

    public int getId() {
        return id;
    }

    public void setTicker(String ticker) {
        String oldTicker = this.ticker;
        this.ticker = ticker;
        propertyChangeSupport.firePropertyChange("ticker", oldTicker, ticker);
    }

    public String getTicker() {
        return ticker;
    }

    public void setCompany(String company) {
        String oldCompany = this.company;
        this.company = company;
        propertyChangeSupport.firePropertyChange("company", oldCompany, company);
    }

    public String getCompany() {
        return company;
    }

    public void setPrice(Double price) {
        Double oldPrice = this.price;
        this.price = price;
        propertyChangeSupport.firePropertyChange("price", oldPrice, price);
    }

    public Double getPrice() {
        return price;
    }

    public void setPrevious(Double previous) {
        Double oldPrevious = this.previous;
        this.previous = previous;
        propertyChangeSupport.firePropertyChange("previous", oldPrevious, previous);
    }

    public Double getPrevious() {
        return previous;
    }

    public void setVolume(Long volume) {
        Long oldVolume = this.volume;
        this.volume = volume;
        propertyChangeSupport.firePropertyChange("volume", oldVolume, volume);
    }

    public Long getVolume() {
        return volume;
    }
}
