package Portfolio;

import com.sun.util.logging.Level;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

import oracle.adfmf.java.beans.PropertyChangeListener;
import oracle.adfmf.java.beans.PropertyChangeSupport;
import oracle.adfmf.java.beans.ProviderChangeListener;
import oracle.adfmf.java.beans.ProviderChangeSupport;
import oracle.adfmf.util.Utility;
import oracle.adfmf.util.logging.Trace;

public class Portfolio {
    protected transient ProviderChangeSupport providerChangeSupport = new ProviderChangeSupport(this);

    private static List s_stocks = null;
    private Stock newStock = new Stock(0, "", "", new Double(1.0), new Double(1.0), new Long(1000));
    private Refresher refresher = new Refresher(this);
    private Thread worker = new Thread(refresher);
    private String deleteTicker = "";
    private boolean threadStarted = false;
    private transient PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public void addProviderChangeListener(ProviderChangeListener l) {
        providerChangeSupport.addProviderChangeListener(l);
    }

    public void removeProviderChangeListener(ProviderChangeListener l) {
        providerChangeSupport.removeProviderChangeListener(l);
    }

    public Portfolio() {
        if (s_stocks == null) {
            s_stocks = new ArrayList();
        }
        ResetStocks();
    }

    public synchronized void ResetStocks() {
        s_stocks.clear();

        s_stocks.add((new Stock(0, "ORCL", "Oracle Corp.", new Double(28.55), new Double(27.15), new Long(9919000))));
        s_stocks.add((new Stock(1, "MSFT", "Microsoft Corp", new Double(32.29), new Double(34.00),
                                new Long(22454330))));
        s_stocks.add((new Stock(2, "AAPL", "Apple Inc.", new Double(392.51), new Double(389.30), new Long(6559023))));
        s_stocks.add((new Stock(3, "RIMM", "Research In Motion Limited", new Double(30.02), new Double(30.72),
                                new Long(7340100))));
        s_stocks.add((new Stock(4, "GOOG", "Google Inc.", new Double(537.93), new Double(532.07), new Long(908766))));
        providerChangeSupport.fireProviderRefresh("stocks");
    }

    public synchronized Stock[] getStocks() {
        Stock s[] = null;

        s = (Stock[])s_stocks.toArray(new Stock[s_stocks.size()]);

        return s;
    }


    public synchronized void DoChange() {
        Random r = new Random(new Random().nextInt(1000));

        int i = 0;
        while (i < s_stocks.size()) {
            Stock s = (Stock)s_stocks.get(i);
            int ran = r.nextInt(1000);
            double change = ((double)ran - 500) / 10000 + 1;
            s.setPrice(new Double(s.getPrice().doubleValue() * change));
            s_stocks.set(i, s);
            i++;
        }
    }

    public void setNewStock(Stock newStock) {
        Trace.log(Utility.ApplicationLogger, Level.INFO, Portfolio.class, "setNewStock",
                  "##################Inside setNewStock!!!");
        this.newStock = newStock;
    }

    public Stock getNewStock() {
        return newStock;
    }

    public void InitNewStock() {
        Trace.log(Utility.ApplicationLogger, Level.INFO, Portfolio.class, "InitNewStock",
                  "##################Inside InitNewStock!!!");
        newStock.setId(0);
        newStock.setTicker("");
        newStock.setCompany("");
        newStock.setPrice(new Double(1.0));
        newStock.setPrevious(new Double(1.0));
        newStock.setVolume(new Long(1000));
    }

    public synchronized void AddNewStock() {
        Trace.log(Utility.ApplicationLogger, Level.INFO, Portfolio.class, "AddNewStock",
                  "##################Inside AddNewStock!!!");
        int newId = 0;
        int size = s_stocks.size();
        for (int i = 0; i < size; i++) {
            Stock s = (Stock)s_stocks.get(i);
            if (s.getId() > newId) {
                newId = s.getId() + 1;
            }
        }


        Stock stock =
            new Stock(newId, newStock.getTicker(), newStock.getCompany(), newStock.getPrice(), newStock.getPrevious(),
                      newStock.getVolume());

        s_stocks.add(stock);
        providerChangeSupport.fireProviderCreate("stocks", stock.getTicker(), stock);
    }

    public synchronized void RemoveStock(String ticker) {
        Stock stock = null;

        int size = s_stocks.size();
        for (int i = 0; i < size; i++) {
            Stock s = (Stock)s_stocks.get(i);
            if (s.getTicker().compareTo(ticker) == 0) {
                setDeleteTicker("");
                stock = (Stock)s_stocks.remove(i);
                providerChangeSupport.fireProviderDelete("stocks", stock.getTicker());
                break;
            }
        }
    }

    public void StartRefresher() {
        setThreadStarted(true);
        refresher.go = true;
        if (!worker.isAlive()) {
            worker.start();
        }
        setThreadStarted(refresher.go);
    }

    public void StopRefresher() {
        if (refresher.go == true) {
            refresher.go = false;
            setThreadStarted(false);
        }
    }


    public void setDeleteTicker(String deleteTicker) {
        String oldDeleteTicker = this.deleteTicker;
        this.deleteTicker = deleteTicker;
        propertyChangeSupport.firePropertyChange("deleteTicker", oldDeleteTicker, deleteTicker);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        propertyChangeSupport.removePropertyChangeListener(l);
    }

    public String getDeleteTicker() {
        return deleteTicker;
    }

    public void setThreadStarted(boolean threadStarted) {
        boolean oldThreadStarted = this.threadStarted;
        this.threadStarted = threadStarted;
        propertyChangeSupport.firePropertyChange("threadStarted", oldThreadStarted, threadStarted);
    }

    public boolean getThreadStarted() {
        return threadStarted;
    }
}
