package mobile;

import java.math.BigDecimal;

import oracle.adfmf.java.beans.PropertyChangeListener;
import oracle.adfmf.java.beans.PropertyChangeSupport;

public class RESTJSONResponse {
    private transient PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public RESTJSONResponse() {
        super();
    }
    
    private String ip;
    private String country_code;
    private String country_name;
    private String region_code;
    private String region_name;
    private String city;
    private String zipcode;
    private BigDecimal latitude;
    private BigDecimal longitude;
    private String metrocode;

    public void addPropertyChangeListener(PropertyChangeListener l) {
        propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        propertyChangeSupport.removePropertyChangeListener(l);
    }

    public void setIp(String ip) {
        String oldIp = this.ip;
        this.ip = ip;
        propertyChangeSupport.firePropertyChange("ip", oldIp, ip);
    }

    public String getIp() {
        return ip;
    }


    public void setCountry_code(String country_code) {
        String oldCountry_code = this.country_code;
        this.country_code = country_code;
        propertyChangeSupport.firePropertyChange("country_code", oldCountry_code, country_code);
    }

    public String getCountry_code() {
        return country_code;
    }

    public void setCountry_name(String country_name) {
        String oldCountry_name = this.country_name;
        this.country_name = country_name;
        propertyChangeSupport.firePropertyChange("country_name", oldCountry_name, country_name);
    }

    public String getCountry_name() {
        return country_name;
    }

    public void setRegion_code(String region_code) {
        String oldRegion_code = this.region_code;
        this.region_code = region_code;
        propertyChangeSupport.firePropertyChange("region_code", oldRegion_code, region_code);
    }

    public String getRegion_code() {
        return region_code;
    }

    public void setRegion_name(String region_name) {
        String oldRegion_name = this.region_name;
        this.region_name = region_name;
        propertyChangeSupport.firePropertyChange("region_name", oldRegion_name, region_name);
    }

    public String getRegion_name() {
        return region_name;
    }

    public void setCity(String city) {
        String oldCity = this.city;
        this.city = city;
        propertyChangeSupport.firePropertyChange("city", oldCity, city);
    }

    public String getCity() {
        return city;
    }

    public void setZipcode(String zipcode) {
        String oldZipcode = this.zipcode;
        this.zipcode = zipcode;
        propertyChangeSupport.firePropertyChange("zipcode", oldZipcode, zipcode);
    }

    public String getZipcode() {
        return zipcode;
    }

    public void setLatitude(BigDecimal latitude) {
        BigDecimal oldLatitude = this.latitude;
        this.latitude = latitude;
        propertyChangeSupport.firePropertyChange("latitude", oldLatitude, latitude);
    }

    public BigDecimal getLatitude() {
        return latitude;
    }

    public void setLongitude(BigDecimal longitude) {
        BigDecimal oldLongitude = this.longitude;
        this.longitude = longitude;
        propertyChangeSupport.firePropertyChange("longitude", oldLongitude, longitude);
    }

    public BigDecimal getLongitude() {
        return longitude;
    }

    public void setMetrocode(String metrocode) {
        String oldMetrocode = this.metrocode;
        this.metrocode = metrocode;
        propertyChangeSupport.firePropertyChange("metrocode", oldMetrocode, metrocode);
    }

    public String getMetrocode() {
        return metrocode;
    }

}
