package mobile;

import oracle.adfmf.dc.ws.rest.RestServiceAdapter;
import oracle.adfmf.framework.api.JSONBeanSerializationHelper;
import oracle.adfmf.framework.api.Model;
import oracle.adfmf.java.beans.PropertyChangeListener;
import oracle.adfmf.java.beans.PropertyChangeSupport;

public class RESTJSONBean {

    private transient PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public RESTJSONBean() {
    }

    private String searchIp = "oracle.com";
    private String jsonResponse = "";
    private RESTJSONResponse response = null;

    public void setSearchIp(String searchIp) {
        String oldSearchIp = this.searchIp;
        this.searchIp = searchIp;
        propertyChangeSupport.firePropertyChange("searchIp", oldSearchIp, searchIp);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        propertyChangeSupport.removePropertyChangeListener(l);
    }

    public String getSearchIp() {
        return searchIp;
    }

    public void setJsonResponse(String response) {
        String oldResponse = this.jsonResponse;
        this.jsonResponse = response;
        propertyChangeSupport.firePropertyChange("jsonResponse", oldResponse, response);
    }

    public String getJsonResponse() {
        return jsonResponse;
    }

    public void setResponse(RESTJSONResponse response) {
        RESTJSONResponse oldResponse = this.response;
        this.response = response;
        propertyChangeSupport.firePropertyChange("response", oldResponse, response);
    }

    public RESTJSONResponse getResponse() {
        return response;
    }

    public void loadData() {
        RestServiceAdapter restServiceAdapter = Model.createRestServiceAdapter();

        // Clear any previously set request properties, if any
        restServiceAdapter.clearRequestProperties();

        // Set the connection name
        restServiceAdapter.setConnectionName("GeoIP");

        // Specify the type of request
        restServiceAdapter.setRequestType(RestServiceAdapter.REQUEST_TYPE_GET);

        // Specify the number of retries
        restServiceAdapter.setRetryLimit(0);

        // Set the URI which is defined after the endpoint in the connections.xml.
        // The request is the endpoint + the URI being set
        restServiceAdapter.setRequestURI("/json/" + getSearchIp());

        setJsonResponse("");

        // Execute SEND and RECEIVE operation
        try {
            // For GET request, there is no payload
            setJsonResponse(restServiceAdapter.send(""));
            
            // Now create a new RESTJSONResponse object and parse the JSON string returned into this class
            RESTJSONResponse res = new RESTJSONResponse();
            res = (RESTJSONResponse)JSONBeanSerializationHelper.fromJSON(RESTJSONResponse.class, getJsonResponse());
            setResponse(res);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}
