package mobile;

import java.io.FileInputStream;

import java.io.FileNotFoundException;

import java.io.IOException;

import javax.el.ValueExpression;

import oracle.adfmf.amx.event.ActionEvent;
import oracle.adfmf.framework.api.AdfmfContainerUtilities;
import oracle.adfmf.framework.api.AdfmfJavaUtilities;

public class MyClass {
    public MyClass() {
    }

    // This method calls the "doAlert" javascript function in the "Javascript" feature and passes in a variable number of params
    public void FireAlerts(ActionEvent actionEvent) {
        AdfmfContainerUtilities.invokeContainerJavaScriptFunction("Javascript", "doAlert", new Object[] {});

        AdfmfContainerUtilities.invokeContainerJavaScriptFunction("Javascript", "doAlert", new Object[] {"arg1"});

        AdfmfContainerUtilities.invokeContainerJavaScriptFunction("Javascript", "doAlert", new Object[] {"arg1", "arg2"});

    }

    // This method calls the "fetchPic" javascript function in the "Javascript" feature with no params
    public void FetchPic(ActionEvent actionEvent) {
        AdfmfContainerUtilities.invokeContainerJavaScriptFunction("Javascript", "fetchPic", new Object[] {});
    }

    // This method calls the "fetchVideo" javascript function in the "Javascript" feature with no params
    public void FetchVideo(ActionEvent actionEvent) {
        AdfmfContainerUtilities.invokeContainerJavaScriptFunction("Javascript", "fetchVideo", new Object[] {});
    }


    // This method will be called by the Javascript method so we show 2-way communication    
    public void FetchCallback(String path) {
        /* Now you have the full path to the file so you can use code like the following to read it 
        FileInputStream file;
        try {
        file = new FileInputStream(path);
            int bytesread = 0;
            byte[] b = new byte[1000];
            do {
                bytesread = file.read(b);
                // now do something with the byte array like copy it somewhere, stream it over a web service, etc
            } while (bytesread < 1000);
            
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
        */

        // We'll simply set a scoped variable that we are displaying on the page
        ValueExpression ve = AdfmfJavaUtilities.getValueExpression("#{pageFlowScope.picpath}", String.class);
        ve.setValue(AdfmfJavaUtilities.getAdfELContext(), path);
        
    }
}
