package HR;

import application.DBConnectionFactory;

import com.sun.util.logging.Level;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import java.util.ArrayList;
import java.util.List;

import oracle.adfmf.util.Utility;
import oracle.adfmf.util.logging.Trace;

public class RegionList {
    private static List s_regions = null;

    public RegionList() {
        if (s_regions == null) {
            s_regions = new ArrayList();
        }
        Execute();
    }

    public void Execute() {
        Trace.log(Utility.ApplicationLogger, Level.INFO, RegionList.class, "Execute",
                  "!!!!!!!!!!!!!!!!!In REGION Execute!!!!!!!!!!!!!!!!!!!!!!!!!");
        try {
            Connection conn = DBConnectionFactory.getConnection();
            s_regions.clear();
            conn.setAutoCommit(false);
            PreparedStatement stat = conn.prepareStatement("SELECT * from REGIONS");
            ResultSet rs = stat.executeQuery();
            Trace.log(Utility.ApplicationLogger, Level.INFO, RegionList.class, "Execute",
                      "!!!!!!!!!!!!!!!!!Query Executed!!!!!!!!!!!!!!!!!!!!!!!!!");
            while (rs.next()) {
                int id = rs.getInt("REGION_ID");
                String name = rs.getString("REGION_NAME");
                Region r = new Region(id, name);
                s_regions.add(r);
            }
            rs.close();
        } catch (SQLException e) {
            System.err.println(e.getMessage());
        } catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    public Region getRegionById(int regionId) {
        Region r = null;
        int count = s_regions.size();
        for (int x = 0; x < count; x++) {
            r = (Region)s_regions.get(x);
            if (r.getId() == regionId) {
                break;
            }
        }
        return r;
    }

    public Region[] getRegions() {
        Region r[] = null;

        r = (Region[])s_regions.toArray(new Region[s_regions.size()]);

        return r;
    }
}
