package HR;

import application.DBConnectionFactory;

import com.sun.util.logging.Level;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import java.util.ArrayList;
import java.util.List;

import oracle.adfmf.util.Utility;
import oracle.adfmf.util.logging.Trace;

public class JobList {
    private static List s_jobs = null;

    public JobList() {
        if (s_jobs == null) {
            s_jobs = new ArrayList();
        }
        Execute();
    }

    public void Execute() {
        Trace.log(Utility.ApplicationLogger, Level.INFO, JobList.class, "Execute",
                  "!!!!!!!!!!!!!!!!!In JOBS Execute!!!!!!!!!!!!!!!!!!!!!!!!!");
        try {
            Connection conn = DBConnectionFactory.getConnection();
            s_jobs.clear();
            conn.setAutoCommit(false);
            PreparedStatement stat = conn.prepareStatement("SELECT * from JOBS ORDER BY JOB_TITLE");
            ResultSet rs = stat.executeQuery();
            Trace.log(Utility.ApplicationLogger, Level.INFO, JobList.class, "Execute",
                      "!!!!!!!!!!!!!!!!!Query Executed!!!!!!!!!!!!!!!!!!!!!!!!!");
            while (rs.next()) {
                Trace.log(Utility.ApplicationLogger, Level.INFO, JobList.class, "Execute",
                          "!!!!!!!!!!!!!!!!!Adding Job!!!!!!!!!!!!!!!!!!!!!!!!!");
                String id = rs.getString("JOB_ID");
                String title = rs.getString("JOB_TITLE");
                int minSalary = rs.getInt("MIN_SALARY");
                int maxSalary = rs.getInt("MAX_SALARY");
                Job j = new Job(id, title, minSalary, maxSalary);
                s_jobs.add(j);
            }
            rs.close();
        } catch (SQLException e) {
            System.err.println(e.getMessage());
        } catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    public Job getJobById(String jobId) {
        Job j = null;
        int count = s_jobs.size();
        for (int x = 0; x < count; x++) {
            j = (Job)s_jobs.get(x);
            if (j.getJobId().compareTo(jobId) == 0) {
                break;
            }
        }
        return j;
    }

    public Job[] getJobs() {
        Job j[] = null;

        j = (Job[])s_jobs.toArray(new Job[s_jobs.size()]);

        return j;
    }
}
