package HR;

import application.DBConnectionFactory;

import com.sun.util.logging.Level;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import java.util.ArrayList;
import java.util.List;

import oracle.adfmf.util.Utility;
import oracle.adfmf.util.logging.Trace;


public class DepartmentList {
    private static List s_departments = null;

    public DepartmentList() {
        if (s_departments == null) {
            s_departments = new ArrayList();
            Execute();
        }
    }

    public void Execute() {
        Trace.log(Utility.ApplicationLogger, Level.INFO, DepartmentList.class, "Execute",
                  "!!!!!!!!!!!!!!!!!In DEPARTMENT Execute!!!!!!!!!!!!!!!!!!!!!!!!!");
        try {
            Connection conn = DBConnectionFactory.getConnection();
            s_departments.clear();
            conn.setAutoCommit(false);
            PreparedStatement stat = conn.prepareStatement("SELECT * from DEPARTMENTS ORDER BY DEPARTMENT_NAME");
            ResultSet rs = stat.executeQuery();
            Trace.log(Utility.ApplicationLogger, Level.INFO, DepartmentList.class, "Execute",
                      "!!!!!!!!!!!!!!!!!Query Executed!!!!!!!!!!!!!!!!!!!!!!!!!");
            while (rs.next()) {
                Trace.log(Utility.ApplicationLogger, Level.INFO, DepartmentList.class, "Execute",
                          "!!!!!!!!!!!!!!!!!Adding Department!!!!!!!!!!!!!!!!!!!!!!!!!");
                int id = rs.getInt("DEPARTMENT_ID");
                String deptName = rs.getString("DEPARTMENT_NAME");
                int mgrId = rs.getInt("MANAGER_ID");
                int locId = rs.getInt("LOCATION_ID");
                Department d = new Department(id, deptName, mgrId, locId);
                s_departments.add(d);
            }
            rs.close();
        } catch (SQLException e) {
            System.err.println(e.getMessage());
        } catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    public Department getDepartmentById(int deptId) {
        Department d = null;
        int count = s_departments.size();
        for (int x = 0; x < count; x++) {
            d = (Department)s_departments.get(x);
            if (d.getDeptId() == deptId) {
                break;
            }
        }
        return d;
    }

    public Department[] getDepartments() {
        Department d[] = null;

        d = (Department[])s_departments.toArray(new Department[s_departments.size()]);

        return d;
    }

}
