package HR;

import oracle.adfmf.java.beans.PropertyChangeListener;
import oracle.adfmf.java.beans.PropertyChangeSupport;

public class Department {
    protected static LocationList locs = new LocationList();
    protected transient Location location = null;
    protected static EmployeeList emps = new EmployeeList();
    protected transient Employee manager = null;
    protected int deptId;
    protected String deptName;
    protected int mgrId;
    protected int locId;
    private transient PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public Department() {
        super();
    }
    
    public Department( int deptId, String deptName, int mgrId, int locId) {
        setDeptId(deptId);
        setDeptName(deptName);
        setMgrId(mgrId);
        setLocId(locId);
    }


    public void setDeptId(int deptId) {
        int oldDeptId = this.deptId;
        this.deptId = deptId;
        propertyChangeSupport.firePropertyChange("deptId", oldDeptId, deptId);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        propertyChangeSupport.removePropertyChangeListener(l);
    }

    public int getDeptId() {
        return deptId;
    }

    public void setDeptName(String deptName) {
        String oldDeptName = this.deptName;
        this.deptName = deptName;
        propertyChangeSupport.firePropertyChange("deptName", oldDeptName, deptName);
    }

    public String getDeptName() {
        return deptName;
    }

    public void setMgrId(int mgrId) {
        int oldMgrId = this.mgrId;
        this.mgrId = mgrId;
        propertyChangeSupport.firePropertyChange("mgrId", oldMgrId, mgrId);
    }

    public int getMgrId() {
        return mgrId;
    }

    public void setLocId(int locId) {
        int oldLocId = this.locId;
        this.locId = locId;
        propertyChangeSupport.firePropertyChange("locId", oldLocId, locId);
    }

    public int getLocId() {
        return locId;
    }
    
    public Location getLocation() {
        if( location == null) {
            location = locs.getLocationById(getLocId());
        }
        return location;
    }
    
    public Employee getManager() {
        if( manager == null) {
            manager = emps.getEmployeeById(getMgrId());
        }
        return manager;
    }
    
}
