package application;

import com.sun.util.logging.Level;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;

import java.sql.Statement;

import java.util.ArrayList;
import java.util.List;

import javax.el.ValueExpression;

import oracle.adfmf.application.LifeCycleListener;
import oracle.adfmf.framework.api.AdfmfJavaUtilities;
import oracle.adfmf.util.Utility;
import oracle.adfmf.util.logging.Trace;

public class LifeCycleListenerImpl implements LifeCycleListener {
    public LifeCycleListenerImpl() {
    }

    /**
     * The start method will be called at the start of the application. Only the
     * Application Lifecycle Event listener will be called on start up.
     */
    public void start() {
        Trace.log(Utility.ApplicationLogger, Level.INFO, LifeCycleListenerImpl.class, "start",
                  "##############App Start");
        try {
            Statement stat = DBConnectionFactory.getConnection().createStatement();
            ResultSet rs = stat.executeQuery("SELECT PIC FROM EMPLOYEES;");
        } catch (SQLException e) {
            // if the error message is "out of memory",
            // it probably means no database file is found
            Trace.log(Utility.ApplicationLogger, Level.INFO, LifeCycleListenerImpl.class, "start",
                      "##############Database does not exist, creating it");
            //            InitDB();
            copyDB();
        } catch (Exception e) {
            Trace.log(Utility.ApplicationLogger, Level.SEVERE, LifeCycleListenerImpl.class, "start",
                      "##############Exception:  " + e.getMessage());
        }
        Trace.log(Utility.ApplicationLogger, Level.INFO, LifeCycleListenerImpl.class, "start",
                  "##############App Start Complete");
    }

    /**
     * The stop method will be called at the termination of the application. Only
     * the Application Lifecycle Event listener will be called on start up.
     *
     * NOTE: Depending on how the application is being shutdown, this method may
     * or may not be called. Features should save off their state in the deactivate
     * handler.
     */
    public void stop() {
        // Add code here...
    }

    /**
     * The activate method will be called when the feature is activated. The
     * Application Lifecycle Event listener will be called on application
     * being started and resumed.
     */
    public void activate() {
        // Add code here...
    }

    /**
     * The deactivate method will be called when the feature is deactivated. The
     * Application Lifecycle Event listener will be called on application
     * being hibernated.
     */
    public void deactivate() {
        // Add code here...
    }

    private void copyDB() {
        try {
            Trace.log(Utility.ApplicationLogger, Level.INFO, LifeCycleListenerImpl.class, "copyDB",
                      "##############copyDB Start");
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            InputStream in = cl.getResourceAsStream(".adf/META-INF/HR.db");
            String outFile =
                AdfmfJavaUtilities.getDirectoryPathRoot(AdfmfJavaUtilities.ApplicationDirectory) + "/HR.db";

            // blank out the DB file if its already there before we copy it.  
            // We do this in a scoped section so that the File goes out of scope and releases itself
            {
                File f = new File(outFile);
                if( f!= null && f.exists() ) {
                    f.createNewFile();
                }
            }
                
            FileOutputStream out = new FileOutputStream(outFile);

            int b;
            do {
                b = in.read();
                if (b != -1) {
                    out.write(b);
                }
            } while (b != -1);
            in.close();
            out.close();

            Trace.log(Utility.ApplicationLogger, Level.INFO, LifeCycleListenerImpl.class, "InitDB",
                      "##############InitDB Complete");
        } catch (FileNotFoundException e) {
            Trace.log(Utility.ApplicationLogger, Level.SEVERE, LifeCycleListenerImpl.class, "copyDB",
                      "##############Exception:  " + e.getMessage());
        } catch (IOException e) {
            Trace.log(Utility.ApplicationLogger, Level.SEVERE, LifeCycleListenerImpl.class, "copyDB",
                      "##############Exception:  " + e.getMessage());
        }

    }

    private void InitDB() {
        try {
            Trace.log(Utility.ApplicationLogger, Level.INFO, LifeCycleListenerImpl.class, "InitDB",
                      "##############initDB Start");
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            InputStream is = cl.getResourceAsStream(".adf/META-INF/hr.sql");
            if (is == null) {
                Trace.log(Utility.ApplicationLogger, Level.INFO, LifeCycleListenerImpl.class, "InitDB",
                          "##############Could not look up : /META-INF/hr.sql");
                return;
            }

            BufferedReader bReader = new BufferedReader(new InputStreamReader(is));
            List stmts = new ArrayList();
            String strstmt = "";
            String ln = bReader.readLine();
            while (ln != null) {
                if (ln.startsWith("REM") || ln.startsWith("COMMIT")) {
                    ln = bReader.readLine();
                    continue;
                }
                strstmt = strstmt + ln;
                if (strstmt.endsWith(";")) {
                    Trace.log(Utility.ApplicationLogger, Level.INFO, LifeCycleListenerImpl.class, "InitDB",
                              "##############" + strstmt);
                    stmts.add(strstmt);
                    strstmt = "";
                    ln = bReader.readLine();
                    continue;
                }
                ln = bReader.readLine();

            }

            DBConnectionFactory.getConnection().setAutoCommit(false);
            for (int i = 0; i < stmts.size(); i++) {
                Statement pStmt = DBConnectionFactory.getConnection().createStatement();
                pStmt.executeUpdate((String)stmts.get(i));

            }
            DBConnectionFactory.getConnection().commit();
            Trace.log(Utility.ApplicationLogger, Level.INFO, LifeCycleListenerImpl.class, "InitDB",
                      "##############InitDB Complete");
        } catch (Exception e) {
            Trace.log(Utility.ApplicationLogger, Level.SEVERE, LifeCycleListenerImpl.class, "InitDB",
                      "##############Exception:  " + e.getMessage());
        }

    }


}
