package Contacts;

import oracle.adf.model.datacontrols.device.DeviceManager;
import oracle.adf.model.datacontrols.device.DeviceManagerFactory;

import oracle.adf.model.datacontrols.device.Contact;
import oracle.adfmf.java.beans.PropertyChangeListener;
import oracle.adfmf.java.beans.PropertyChangeSupport;

public class ContactBean {
    String contactFields = "birthday,displayname,id,nickname,note,addresses,categories,emails,ims,name,organizations,phoneNumbers,photos,urls";
    String filter = "";
    boolean multiple = true;
    private transient PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public ContactBean() {
        super();
    }

    public void setContactFields(String contactFields) {
        String oldContactFields = this.contactFields;
        this.contactFields = contactFields;
        propertyChangeSupport.firePropertyChange("contactFields", oldContactFields, contactFields);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        propertyChangeSupport.removePropertyChangeListener(l);
    }

    public String getContactFields() {
        return contactFields;
    }

    public void setFilter(String filter) {
        String oldFilter = this.filter;
        this.filter = filter;
        propertyChangeSupport.firePropertyChange("filter", oldFilter, filter);
    }

    public String getFilter() {
        return filter;
    }

    public void setMultiple(boolean multiple) {
        boolean oldMultiple = this.multiple;
        this.multiple = multiple;
        propertyChangeSupport.firePropertyChange("multiple", oldMultiple, multiple);
    }

    public boolean isMultiple() {
        return multiple;
    }
    
    public void findContacts() {
        DeviceManager deviceManager = DeviceManagerFactory.getDeviceManager();
        Contact[] cons = deviceManager.findContacts(contactFields, filter, multiple);
    }
}
