#!/bin/bash

if [ -e ./CompGalleryDemo ]; then
    echo "Deleting existing demo directory..."
    rm -rf ./CompGalleryDemo
fi

echo "Creating CompGalleryDemo directory..."
mkdir CompGalleryDemo

TIMESTAMP="$(/bin/date +%s)"
echo -e "<html><head><meta name='viewport' content='width=device-width'/><meta http-equiv='Refresh' content='1;url=bootstrap.html?file=Gallery/task-flow.xml%23task-flow&timestamp=$TIMESTAMP'/><title>ADF Mobile Mock Gallery</title></head><body>Redirecting...</body></html>" > CompGalleryDemo/index.html

echo "Copying framework files..."
cp -R deploy/IOS_native/temporary_xcode_project/www/* CompGalleryDemo/

echo "Giving the bootstrap a title..."
cd CompGalleryDemo
BOOTSTRAPFILENAME="bootstrap.html"
sed -E -i .bak "s/\<title><\/title\>/\<title>ADF Mobile Mock Gallery (for mobile browsers)<\/title\>/" $BOOTSTRAPFILENAME
rm "$BOOTSTRAPFILENAME.bak"
BUILDCOMMENTSTART="<!-- Build info:"
BUILDTIME="Date: $(/bin/date)"
BUILDPATH="Path: $(/bin/pwd)"
BUILDCOMMENTEND="-->"
NEWLINE="\n"
echo -e "$BUILDCOMMENTSTART $NEWLINE $BUILDPATH $NEWLINE $BUILDTIME $NEWLINE $BUILDCOMMENTEND" >> $BOOTSTRAPFILENAME
cd ..

# remove adf.mf.device.integration.js
rm CompGalleryDemo/js/adf.mf.device.integration.js

echo "Copying application files..."
cp -R deploy/IOS_native/temporary_xcode_project/FARs/ViewController/public_html/* CompGalleryDemo

mv CompGalleryDemo/model.json CompGalleryDemo/model.jso
mv CompGalleryDemo/featureLevelIncludes.json CompGalleryDemo/featureLevelIncludes.jso

echo "Neutralizing bean variables..."
#find CompGalleryDemo/ -name \*amx -exec sed -i -e 's/viewScope\.actionevent//' {} \;
#find CompGalleryDemo/ -name \*amx -exec sed -i -e 's/viewScope\.valuechanged//' {} \;
#find CompGalleryDemo/ -name \*amx -exec sed -i -e 's/viewScope\.valuechangeold//' {} \;
#find CompGalleryDemo/ -name \*amx -exec sed -i -e 's/viewScope\.valuechangenew//' {} \;
#find CompGalleryDemo/ -name \*amx -exec sed -i -e 's/viewScope\.movedata//' {} \;
#rm CompGalleryDemo/*amx-e

if [ -e ./CompGalleryDemo.zip ]; then
  echo "Deleting existing zip file..."
  rm CompGalleryDemo.zip
fi
echo "Creating zip file..."
zip -r CompGalleryDemo.zip CompGalleryDemo/*
