package mobile;

import com.sun.util.logging.Level;

import java.util.Map;

import javax.el.ValueExpression;

import oracle.adfmf.amx.event.ActionEvent;
import oracle.adfmf.amx.event.MoveEvent;
import oracle.adfmf.amx.event.SelectionEvent;
import oracle.adfmf.amx.event.ValueChangeEvent;
import oracle.adfmf.bindings.dbf.AmxCollectionModel;
import oracle.adfmf.framework.api.AdfmfJavaUtilities;
import oracle.adfmf.util.Utility;
import oracle.adfmf.util.logging.Trace;

public class PropertyBean
{
  public PropertyBean()
  {
  }

  public void ResetProperties(ActionEvent actionEvent)
  {
    ValueExpression ve;

    ve = AdfmfJavaUtilities.getValueExpression("#{viewScope.actionevent}", String.class);
    ve.setValue(AdfmfJavaUtilities.getAdfELContext(), "");
    ve = AdfmfJavaUtilities.getValueExpression("#{viewScope.valuechanged}", String.class);
    ve.setValue(AdfmfJavaUtilities.getAdfELContext(), "");
    ve = AdfmfJavaUtilities.getValueExpression("#{viewScope.valuechangeold}", String.class);
    ve.setValue(AdfmfJavaUtilities.getAdfELContext(), "");
    ve = AdfmfJavaUtilities.getValueExpression("#{viewScope.valuechangenew}", String.class);
    ve.setValue(AdfmfJavaUtilities.getAdfELContext(), "");
    ve = AdfmfJavaUtilities.getValueExpression("#{viewScope.movedata}", String.class);
    ve.setValue(AdfmfJavaUtilities.getAdfELContext(), "");
  }

  public void ActionHandler(ActionEvent actionEvent)
  {
    ValueExpression ve;

    ve = AdfmfJavaUtilities.getValueExpression("#{viewScope.actionevent}", String.class);
    ve.setValue(AdfmfJavaUtilities.getAdfELContext(), "Action Fired!");
  }

  public void ValueChangeHandler(ValueChangeEvent valueChangeEvent)
  {
    Trace.log(Utility.ApplicationLogger, Level.INFO, PropertyBean.class, "ValueChangeHandler",
              "##############Inside ValueChangeHandler");
    ValueExpression ve;

    ve = AdfmfJavaUtilities.getValueExpression("#{viewScope.valuechanged}", String.class);
    ve.setValue(AdfmfJavaUtilities.getAdfELContext(), "Value Changed!");

    String oldstr = "";
    String newstr = "";
    Object value = null;

    value = valueChangeEvent.getOldValue();
    if (value != null)
    {
      oldstr = value.toString();
    }

    value = valueChangeEvent.getNewValue();
    if (value != null)
    {
      newstr = value.toString();
    }

    String oldval = "Old Value: " + oldstr;
    String newval = "New Value: " + newstr;

    ve = AdfmfJavaUtilities.getValueExpression("#{viewScope.valuechangeold}", String.class);
    ve.setValue(AdfmfJavaUtilities.getAdfELContext(), oldval);

    ve = AdfmfJavaUtilities.getValueExpression("#{viewScope.valuechangenew}", String.class);
    ve.setValue(AdfmfJavaUtilities.getAdfELContext(), newval);
    Trace.log(Utility.ApplicationLogger, Level.INFO, PropertyBean.class, "ValueChangeHandler",
              "##############ValueChangeHandler completed");
  }

  public void ThematicMapSelectionHandler(SelectionEvent selectionEvent)
  {
    ValueExpression ve1 =
      AdfmfJavaUtilities.getValueExpression("#{bindings.thematicMapData.collectionModel}", AmxCollectionModel.class);
    AmxCollectionModel model = (AmxCollectionModel) ve1.getValue(AdfmfJavaUtilities.getAdfELContext());


    String[] selectedRowKeys = selectionEvent.getSelectedRowKeys();
    StringBuffer buffer = new StringBuffer();
    if (selectedRowKeys != null)
    {
      for (int i = 0; i < selectedRowKeys.length; i++)
      {
        String key = selectedRowKeys[i];
        Map provider = (Map) model.getProviders().get(key);
        buffer.append(provider.get("name"));
        if (i < selectedRowKeys.length - 1)
        {
          buffer.append(", ");
        }
      }
    }

    ValueExpression ve = AdfmfJavaUtilities.getValueExpression("#{viewScope.valuechangenew}", String.class);
    ve.setValue(AdfmfJavaUtilities.getAdfELContext(), buffer.toString());
  }

  public void GeographicMapPointDataSelectionHandler(SelectionEvent selectionEvent)
  {
    ValueExpression ve1 =
      AdfmfJavaUtilities.getValueExpression("#{bindings.geographicMapPointData.collectionModel}", AmxCollectionModel.class);
    AmxCollectionModel model = (AmxCollectionModel) ve1.getValue(AdfmfJavaUtilities.getAdfELContext());


    String[] selectedRowKeys = selectionEvent.getSelectedRowKeys();
    StringBuffer buffer = new StringBuffer();
    if (selectedRowKeys != null)
    {
      for (int i = 0; i < selectedRowKeys.length; i++)
      {
        String key = selectedRowKeys[i];
        Map provider = (Map) model.getProviders().get(key);
        buffer.append(provider.get("shortDesc"));
        if (i < selectedRowKeys.length - 1)
        {
          buffer.append(", ");
        }
      }
    }

    ValueExpression ve = AdfmfJavaUtilities.getValueExpression("#{viewScope.valuechangenew}", String.class);
    ve.setValue(AdfmfJavaUtilities.getAdfELContext(), buffer.toString());
  }

  public void GeographicMapAddressDataSelectionHandler(SelectionEvent selectionEvent)
  {
    ValueExpression ve1 =
      AdfmfJavaUtilities.getValueExpression("#{bindings.geographicMapAddressData.collectionModel}", AmxCollectionModel.class);
    AmxCollectionModel model = (AmxCollectionModel) ve1.getValue(AdfmfJavaUtilities.getAdfELContext());


    String[] selectedRowKeys = selectionEvent.getSelectedRowKeys();
    StringBuffer buffer = new StringBuffer();
    if (selectedRowKeys != null)
    {
      for (int i = 0; i < selectedRowKeys.length; i++)
      {
        String key = selectedRowKeys[i];
        Map provider = (Map) model.getProviders().get(key);
        buffer.append(provider.get("shortDesc"));
        if (i < selectedRowKeys.length - 1)
        {
          buffer.append(", ");
        }
      }
    }

    ValueExpression ve = AdfmfJavaUtilities.getValueExpression("#{viewScope.valuechangenew}", String.class);
    ve.setValue(AdfmfJavaUtilities.getAdfELContext(), buffer.toString());
  }

  public void MoveHandler(MoveEvent moveEvent)
  {
    Trace.log(Utility.ApplicationLogger, Level.INFO, PropertyBean.class, "MoveHandler", "MoveListener Called!!");

    String inserted = "null";
    if (moveEvent.getRowKeyInsertedBefore() != null)
      inserted = (String) moveEvent.getRowKeyInsertedBefore().toString();

    String key = "null";
    if (moveEvent.getRowKeyMoved() != null)
      key = (String) moveEvent.getRowKeyMoved();

    Trace.log(Utility.ApplicationLogger, Level.INFO, PropertyBean.class, "MoveHandler",
              "MoveListener Called:  Item Moved: " + key + ",  Inserted before: " + inserted);

    ValueExpression ve;
    ve = AdfmfJavaUtilities.getValueExpression("#{viewScope.movedata}", String.class);
    ve.setValue(AdfmfJavaUtilities.getAdfELContext(), "Item Moved: " + key + ",  Inserted before: " + inserted);

    Trace.log(Utility.ApplicationLogger, Level.INFO, PropertyBean.class, "MoveHandler", "MoveListener Completed!!");
  }

    public void thematicMapBaseMapChanged(ValueChangeEvent valueChangeEvent) {
        String newVal = valueChangeEvent.getNewValue().toString();
        ValueExpression ve = AdfmfJavaUtilities.getValueExpression("#{pageFlowScope.layer}", String.class);
        String layer = "countries";
        if (newVal.equals("africa") || newVal.equals("asia") || newVal.equals("australia") || newVal.equals("europe") || newVal.equals("northAmerica") || newVal.equals("southAmerica")) {
           layer = "continent";   
        } else if (newVal.equals("usa")) {
           layer = "country";
        } else if (newVal.equals("world")) {
           layer = "continents";
        }
        Trace.log(Utility.ApplicationLogger, Level.INFO, PropertyBean.class, "thematicMapBaseMapChanged", "New value: "+layer);
        ve.setValue(AdfmfJavaUtilities.getAdfELContext(), layer);
    }
}
